/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.dcmqrscp;

import java.io.IOException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.pdu.RoleSelection;
import org.dcm4che3.tool.dcmqrscp.DcmQRSCP;

class SendStgCmtResult
implements Runnable {
    private final Association as;
    private final Attributes eventInfo;
    private final boolean sameAssoc;
    private final Connection remoteConn;

    SendStgCmtResult(Association as, Attributes eventInfo, boolean sameAssoc, Connection remoteConn) {
        this.as = as;
        this.eventInfo = eventInfo;
        this.sameAssoc = sameAssoc;
        this.remoteConn = remoteConn;
    }

    @Override
    public void run() {
        if (this.sameAssoc) {
            try {
                this.neventReport(this.as);
                return;
            }
            catch (Exception e) {
                DcmQRSCP.LOG.info("Failed to return Storage Commitment Result in same Association:", (Throwable)e);
            }
        }
        try {
            Association diffAssoc = this.as.getApplicationEntity().connect(this.as.getConnection(), this.remoteConn, this.makeAAssociateRQ());
            this.neventReport(diffAssoc);
            diffAssoc.release();
        }
        catch (Exception e) {
            DcmQRSCP.LOG.error("Failed to return Storage Commitment Result in new Association:", (Throwable)e);
        }
    }

    private void neventReport(Association as) throws IOException, InterruptedException {
        as.neventReport("1.2.840.10008.1.20.1", "1.2.840.10008.1.20.1.1", this.eventTypeId(this.eventInfo), this.eventInfo, null).next();
    }

    private int eventTypeId(Attributes eventInfo) {
        return eventInfo.containsValue(528792) ? 2 : 1;
    }

    private AAssociateRQ makeAAssociateRQ() {
        AAssociateRQ aarq = new AAssociateRQ();
        aarq.setCallingAET(this.as.getLocalAET());
        aarq.setCalledAET(this.as.getRemoteAET());
        ApplicationEntity ae = this.as.getApplicationEntity();
        TransferCapability tc = ae.getTransferCapabilityFor("1.2.840.10008.1.20.1", TransferCapability.Role.SCP);
        aarq.addPresentationContext(new PresentationContext(1, "1.2.840.10008.1.20.1", tc.getTransferSyntaxes()));
        aarq.addRoleSelection(new RoleSelection("1.2.840.10008.1.20.1", false, true));
        return aarq;
    }
}

