/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.dcmqrscp;

import java.io.IOException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.tool.dcmqrscp.DcmQRSCP;
import org.dcm4che3.tool.dcmqrscp.StudyQueryTask;
import org.dcm4che3.util.StringUtils;

class SeriesQueryTask
extends StudyQueryTask {
    protected final String[] seriesIUIDs;
    protected Attributes seriesRec;

    public SeriesQueryTask(Association as, PresentationContext pc, Attributes rq, Attributes keys, DcmQRSCP qrscp) throws DicomServiceException {
        super(as, pc, rq, keys, qrscp);
        this.seriesIUIDs = StringUtils.maskNull((String[])keys.getStrings(0x20000E));
        this.wrappedFindNextSeries();
    }

    @Override
    public boolean hasMoreMatches() throws DicomServiceException {
        return this.seriesRec != null;
    }

    @Override
    public Attributes nextMatch() throws DicomServiceException {
        Attributes ret = new Attributes(this.patRec.size() + this.studyRec.size() + this.seriesRec.size());
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{this.patRec, this.studyRec, this.seriesRec});
        ret.addAll(this.patRec);
        ret.addAll(this.studyRec, true);
        ret.addAll(this.seriesRec, true);
        this.wrappedFindNextSeries();
        return ret;
    }

    private void wrappedFindNextSeries() throws DicomServiceException {
        try {
            this.findNextSeries();
        }
        catch (IOException e) {
            throw new DicomServiceException(49152, (Throwable)e);
        }
    }

    protected boolean findNextSeries() throws IOException {
        if (this.studyRec == null) {
            return false;
        }
        this.seriesRec = this.seriesRec == null ? this.ddr.findSeriesRecord(this.studyRec, this.keys, this.recFact, this.ignoreCaseOfPN, this.matchNoValue) : (this.seriesIUIDs.length == 1 ? null : this.ddr.findNextSeriesRecord(this.seriesRec, this.keys, this.recFact, this.ignoreCaseOfPN, this.matchNoValue));
        while (this.seriesRec == null && super.findNextStudy()) {
            this.seriesRec = this.ddr.findSeriesRecord(this.studyRec, this.keys, this.recFact, this.ignoreCaseOfPN, this.matchNoValue);
        }
        return this.seriesRec != null;
    }
}

