/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.dcmqrscp;

import java.io.IOException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.tool.dcmqrscp.DcmQRSCP;
import org.dcm4che3.tool.dcmqrscp.PatientQueryTask;
import org.dcm4che3.util.StringUtils;

class StudyQueryTask
extends PatientQueryTask {
    protected final String[] studyIUIDs;
    protected Attributes studyRec;

    public StudyQueryTask(Association as, PresentationContext pc, Attributes rq, Attributes keys, DcmQRSCP qrscp) throws DicomServiceException {
        super(as, pc, rq, keys, qrscp);
        this.studyIUIDs = StringUtils.maskNull((String[])keys.getStrings(0x20000D));
        this.wrappedFindNextStudy();
    }

    @Override
    public boolean hasMoreMatches() throws DicomServiceException {
        return this.studyRec != null;
    }

    @Override
    public Attributes nextMatch() throws DicomServiceException {
        Attributes ret = new Attributes(this.patRec.size() + this.studyRec.size());
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{this.patRec, this.studyRec});
        ret.addAll(this.patRec);
        ret.addAll(this.studyRec, true);
        this.wrappedFindNextStudy();
        return ret;
    }

    private void wrappedFindNextStudy() throws DicomServiceException {
        try {
            this.findNextStudy();
        }
        catch (IOException e) {
            throw new DicomServiceException(49152, (Throwable)e);
        }
    }

    protected boolean findNextStudy() throws IOException {
        if (this.patRec == null) {
            return false;
        }
        this.studyRec = this.studyRec == null ? this.ddr.findStudyRecord(this.patRec, this.keys, this.recFact, this.ignoreCaseOfPN, this.matchNoValue) : (this.studyIUIDs.length == 1 ? null : this.ddr.findNextStudyRecord(this.studyRec, this.keys, this.recFact, this.ignoreCaseOfPN, this.matchNoValue));
        while (this.studyRec == null && super.findNextPatient()) {
            this.studyRec = this.ddr.findStudyRecord(this.patRec, this.keys, this.recFact, this.ignoreCaseOfPN, this.matchNoValue);
        }
        return this.studyRec != null;
    }
}

