/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.hl72xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.hl7.HL7Charset;
import org.dcm4che3.hl7.HL7Parser;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.tool.common.CLIUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class HL72Xml {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.hl72xml.messages");
    private URL xslt;
    private boolean indent = false;
    private boolean includeNamespaceDeclaration = false;
    private String charset;

    public final void setXSLT(URL xslt) {
        this.xslt = xslt;
    }

    public final void setIndent(boolean indent) {
        this.indent = indent;
    }

    public final void setIncludeNamespaceDeclaration(boolean includeNamespaceDeclaration) {
        this.includeNamespaceDeclaration = includeNamespaceDeclaration;
    }

    public String getCharacterSet() {
        return this.charset;
    }

    public void setCharacterSet(String charset) {
        this.charset = charset;
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        opts.addOption(Option.builder((String)"x").longOpt("xsl").hasArg().argName("xsl-file").desc(rb.getString("xsl")).build());
        opts.addOption(Option.builder().longOpt("charset").hasArg().argName("name").desc(rb.getString("charset")).build());
        opts.addOption("I", "indent", false, rb.getString("indent"));
        opts.addOption(null, "xmlns", false, rb.getString("xmlns"));
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, HL72Xml.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block8: {
            try {
                CommandLine cl = HL72Xml.parseComandLine(args);
                HL72Xml main = new HL72Xml();
                if (cl.hasOption("x")) {
                    String s = cl.getOptionValue("x");
                    main.setXSLT(new File(s).toURI().toURL());
                }
                main.setCharacterSet(cl.getOptionValue("charset"));
                main.setIndent(cl.hasOption("I"));
                main.setIncludeNamespaceDeclaration(cl.hasOption("xmlns"));
                String fname = HL72Xml.fname(cl.getArgList());
                if (fname.equals("-")) {
                    main.parse(System.in);
                    break block8;
                }
                try (FileInputStream dis = new FileInputStream(fname);){
                    main.parse(dis);
                }
            }
            catch (ParseException e) {
                System.err.println("hl72xml: " + e.getMessage());
                System.err.println(rb.getString("try"));
                System.exit(2);
            }
            catch (Exception e) {
                System.err.println("hl72xml: " + e.getMessage());
                e.printStackTrace();
                System.exit(2);
            }
        }
    }

    private static String fname(List<String> argList) throws ParseException {
        int numArgs = argList.size();
        if (numArgs == 0) {
            throw new ParseException(rb.getString("missing"));
        }
        if (numArgs > 1) {
            throw new ParseException(rb.getString("too-many"));
        }
        return argList.get(0);
    }

    public void parse(InputStream is) throws IOException, TransformerConfigurationException, SAXException {
        byte[] buf = new byte[256];
        int len = is.read(buf);
        HL7Segment msh = HL7Segment.parseMSH((byte[])buf, (int)buf.length);
        String charsetName = HL7Charset.toCharsetName((String)msh.getField(17, this.charset));
        InputStreamReader reader = new InputStreamReader((InputStream)new SequenceInputStream(new ByteArrayInputStream(buf, 0, len), is), charsetName);
        TransformerHandler th = this.getTransformerHandler();
        th.getTransformer().setOutputProperty("indent", this.indent ? "yes" : "no");
        th.setResult(new StreamResult(System.out));
        HL7Parser hl7Parser = new HL7Parser((ContentHandler)th);
        hl7Parser.setIncludeNamespaceDeclaration(this.includeNamespaceDeclaration);
        hl7Parser.parse((Reader)reader);
    }

    private TransformerHandler getTransformerHandler() throws TransformerConfigurationException, IOException {
        SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        if (this.xslt == null) {
            return tf.newTransformerHandler();
        }
        TransformerHandler th = tf.newTransformerHandler(new StreamSource(this.xslt.openStream(), this.xslt.toExternalForm()));
        return th;
    }
}

