/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.hl7pix;

import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.hl7.HL7Message;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.hl7.MLLPConnection;
import org.dcm4che3.hl7.MLLPRelease;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.IncompatibleConnectionException;
import org.dcm4che3.tool.common.CLIUtils;

public class HL7Pix
extends Device {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.hl7pix.messages");
    private final Connection conn = new Connection();
    private final Connection remote = new Connection();
    private MLLPRelease mllpRelease;
    private String sendingApplication = "hl7pix^dcm4che";
    private String receivingApplication = "";
    private String charset;
    private Socket sock;
    private MLLPConnection mllp;

    public HL7Pix() throws IOException {
        super("hl7pix");
        this.addConnection(this.conn);
    }

    public void setMLLPRelease(MLLPRelease mllpRelease) {
        this.mllpRelease = mllpRelease;
    }

    public String getSendingApplication() {
        return this.sendingApplication;
    }

    public void setSendingApplication(String sendingApplication) {
        this.sendingApplication = sendingApplication;
    }

    public String getReceivingApplication() {
        return this.receivingApplication;
    }

    public void setReceivingApplication(String receivingApplication) {
        this.receivingApplication = receivingApplication;
    }

    public void setCharacterSet(String charset) {
        this.charset = charset;
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        HL7Pix.addConnectOption(opts);
        HL7Pix.addBindOption(opts);
        HL7Pix.addCharsetOption(opts);
        CLIUtils.addMLLP2Option((Options)opts);
        CLIUtils.addResponseTimeoutOption((Options)opts);
        CLIUtils.addSocketOptions((Options)opts);
        CLIUtils.addTLSOptions((Options)opts);
        CLIUtils.addCommonOptions((Options)opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, HL7Pix.class);
    }

    private static void addCharsetOption(Options opts) {
        opts.addOption(Option.builder().longOpt("charset").hasArg().argName("name").desc(rb.getString("charset")).build());
    }

    private static void addConnectOption(Options opts) {
        opts.addOption(Option.builder((String)"c").hasArg().argName("app^fac@host:port").desc(rb.getString("connect")).longOpt("connect").build());
        opts.addOption(Option.builder().hasArg().argName("[user:password@]host:port").desc(rb.getString("proxy")).longOpt("proxy").build());
        CLIUtils.addConnectTimeoutOption((Options)opts);
    }

    private static void addBindOption(Options opts) {
        opts.addOption(Option.builder((String)"b").hasArg().argName("app^fac[@ip]").desc(rb.getString("bind")).longOpt("bind").build());
    }

    private static void configureConnect(HL7Pix hl7pix, CommandLine cl) throws MissingOptionException, ParseException {
        String appAtHostPort = cl.getOptionValue("c");
        if (appAtHostPort == null) {
            throw new MissingOptionException(CLIUtils.rb.getString("missing-connect-opt"));
        }
        String[] appHostPort = HL7Segment.split((String)appAtHostPort, (char)'@');
        if (appHostPort.length != 2) {
            throw new ParseException(CLIUtils.rb.getString("invalid-connect-opt"));
        }
        String[] hostPort = HL7Segment.split((String)appHostPort[1], (char)':');
        if (hostPort.length != 2) {
            throw new ParseException(CLIUtils.rb.getString("invalid-connect-opt"));
        }
        hl7pix.setReceivingApplication(appHostPort[0]);
        hl7pix.remote.setHostname(hostPort[0]);
        hl7pix.remote.setPort(Integer.parseInt(hostPort[1]));
        hl7pix.remote.setHttpProxy(cl.getOptionValue("proxy"));
    }

    private static void configureBind(HL7Pix hl7pix, CommandLine cl) {
        String appAtHost = cl.getOptionValue("b");
        if (appAtHost != null) {
            String[] appHost = HL7Segment.split((String)appAtHost, (char)'@');
            hl7pix.setSendingApplication(appHost[0]);
            if (appHost.length > 1) {
                hl7pix.conn.setHostname(appHost[1]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            CommandLine cl = HL7Pix.parseComandLine(args);
            HL7Pix main = new HL7Pix();
            HL7Pix.configureConnect(main, cl);
            HL7Pix.configureBind(main, cl);
            CLIUtils.configure((Connection)main.conn, (CommandLine)cl);
            main.setMLLPRelease(CLIUtils.isMLLP2((CommandLine)cl) ? MLLPRelease.MLLP2 : MLLPRelease.MLLP1);
            main.setCharacterSet(cl.getOptionValue("charset"));
            main.remote.setTlsProtocols(main.conn.getTlsProtocols());
            main.remote.setTlsCipherSuites(main.conn.getTlsCipherSuites());
            List argList = cl.getArgList();
            if (argList.isEmpty()) {
                throw new ParseException(rb.getString("missing"));
            }
            try {
                main.open();
                main.query((String)argList.get(0), argList.subList(1, argList.size()).toArray(new String[0]));
            }
            finally {
                main.close();
            }
        }
        catch (ParseException e) {
            System.err.println("hl7pix: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("hl7pix: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    public void open() throws IOException, IncompatibleConnectionException, GeneralSecurityException {
        this.sock = this.conn.connect(this.remote);
        this.sock.setSoTimeout(this.conn.getResponseTimeout());
        this.mllp = new MLLPConnection(this.sock, this.mllpRelease);
    }

    public void close() {
        this.conn.close(this.sock);
    }

    public void query(String pid, String[] domains) throws IOException {
        HL7Message qbp = HL7Message.makePixQuery((String)pid, (String[])domains);
        HL7Segment msh = (HL7Segment)qbp.get(0);
        msh.setSendingApplicationWithFacility(this.sendingApplication);
        msh.setReceivingApplicationWithFacility(this.receivingApplication);
        msh.setField(17, this.charset);
        this.mllp.writeMessage(qbp.getBytes(this.charset));
        if (this.mllp.readMessage() == null) {
            throw new IOException("Connection closed by receiver");
        }
    }
}

