/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.ianscp;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Commands;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.DimseRQHandler;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.AbstractDicomService;
import org.dcm4che3.net.service.BasicCEchoSCP;
import org.dcm4che3.net.service.DicomService;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.DicomServiceRegistry;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.SafeClose;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IanSCP
extends Device {
    private static final Logger LOG = LoggerFactory.getLogger(IanSCP.class);
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.ianscp.messages");
    private final ApplicationEntity ae = new ApplicationEntity("*");
    private final Connection conn = new Connection();
    private File storageDir;
    private int status;
    private final DicomService ianSCP = new AbstractDicomService(new String[]{"1.2.840.10008.5.1.4.33"}){

        public void onDimseRQ(Association as, PresentationContext pc, Dimse dimse, Attributes cmd, Attributes data) throws IOException {
            if (dimse != Dimse.N_CREATE_RQ) {
                throw new DicomServiceException(529);
            }
            Attributes rsp = Commands.mkNCreateRSP((Attributes)cmd, (int)IanSCP.this.status);
            Attributes rspAttrs = IanSCP.this.create(as, cmd, data);
            as.tryWriteDimseRSP(pc, rsp, rspAttrs);
        }
    };

    public IanSCP() throws IOException {
        super("ianscp");
        this.addConnection(this.conn);
        this.addApplicationEntity(this.ae);
        this.ae.setAssociationAcceptor(true);
        this.ae.addConnection(this.conn);
        DicomServiceRegistry serviceRegistry = new DicomServiceRegistry();
        serviceRegistry.addDicomService((DicomService)new BasicCEchoSCP());
        serviceRegistry.addDicomService(this.ianSCP);
        this.ae.setDimseRQHandler((DimseRQHandler)serviceRegistry);
    }

    public void setStorageDirectory(File storageDir) {
        if (storageDir != null) {
            storageDir.mkdirs();
        }
        this.storageDir = storageDir;
    }

    public File getStorageDirectory() {
        return this.storageDir;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = IanSCP.parseComandLine(args);
            IanSCP main = new IanSCP();
            CLIUtils.configureBindServer((Connection)main.conn, (ApplicationEntity)main.ae, (CommandLine)cl);
            CLIUtils.configure((Connection)main.conn, (CommandLine)cl);
            CLIUtils.configureAcceptedCallingAETitles((ApplicationEntity)main.ae, (CommandLine)cl, (Logger)LOG);
            IanSCP.configureTransferCapability(main.ae, cl);
            main.setStatus(CLIUtils.getIntOption((CommandLine)cl, (String)"status", (int)0));
            main.setStorageDirectory(IanSCP.getStorageDirectory(cl));
            ExecutorService executorService = Executors.newCachedThreadPool();
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            main.setScheduledExecutor(scheduledExecutorService);
            main.setExecutor(executorService);
            main.bindConnections();
        }
        catch (ParseException e) {
            System.err.println("ianscp: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("ianscp: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addBindServerOption((Options)opts);
        CLIUtils.addAEOptions((Options)opts);
        CLIUtils.addAcceptedCallingAETs((Options)opts);
        CLIUtils.addCommonOptions((Options)opts);
        IanSCP.addStorageDirectoryOptions(opts);
        IanSCP.addTransferCapabilityOptions(opts);
        IanSCP.addStatusOption(opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, IanSCP.class);
    }

    private static void addStorageDirectoryOptions(Options opts) {
        opts.addOption(null, "ignore", false, rb.getString("ignore"));
        opts.addOption(Option.builder().hasArg().argName("path").desc(rb.getString("directory")).longOpt("directory").build());
    }

    private static void addTransferCapabilityOptions(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("file|url").desc(rb.getString("sop-classes")).longOpt("sop-classes").build());
    }

    private static void addStatusOption(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("code").desc(rb.getString("status")).longOpt("status").build());
    }

    private static File getStorageDirectory(CommandLine cl) {
        return cl.hasOption("ignore") ? null : new File(cl.getOptionValue("directory", "."));
    }

    private static void configureTransferCapability(ApplicationEntity ae, CommandLine cl) throws IOException {
        Properties p = CLIUtils.loadProperties((String)cl.getOptionValue("sop-classes", "resource:sop-classes.properties"), null);
        for (String cuid : p.stringPropertyNames()) {
            String ts = p.getProperty(cuid);
            ae.addTransferCapability(new TransferCapability(null, CLIUtils.toUID((String)cuid), TransferCapability.Role.SCP, CLIUtils.toUIDs((String)ts)));
        }
    }

    private Attributes create(Association as, Attributes rq, Attributes rqAttrs) throws DicomServiceException {
        if (this.storageDir == null) {
            return null;
        }
        String cuid = rq.getString(2);
        String iuid = rq.getString(4096);
        File file = new File(this.storageDir, iuid);
        if (file.exists()) {
            throw new DicomServiceException(273).setUID(4096, iuid);
        }
        DicomOutputStream out = null;
        LOG.info("{}: M-WRITE {}", (Object)as, (Object)file);
        try {
            out = new DicomOutputStream(file);
            out.writeDataset(Attributes.createFileMetaInformation((String)iuid, (String)cuid, (String)"1.2.840.10008.1.2.1"), rqAttrs);
        }
        catch (IOException e) {
            try {
                LOG.warn(as + ": Failed to store Instance Available Notification:", (Throwable)e);
                throw new DicomServiceException(272, (Throwable)e);
            }
            catch (Throwable throwable) {
                SafeClose.close(out);
                throw throwable;
            }
        }
        SafeClose.close((Closeable)out);
        return null;
    }
}

