/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.ihe.modality;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.IncompatibleConnectionException;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.tool.common.DicomFiles;
import org.dcm4che3.tool.mkkos.MkKOS;
import org.dcm4che3.tool.mppsscu.MppsSCU;
import org.dcm4che3.tool.stgcmtscu.StgCmtSCU;
import org.dcm4che3.tool.storescu.StoreSCU;
import org.dcm4che3.util.UIDUtils;

public class Modality {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.ihe.modality.messages");
    static BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
    private static String calledAET;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            CommandLine cl = Modality.parseComandLine(args);
            if (cl.getArgList().isEmpty()) {
                throw new MissingOptionException(rb.getString("missing-i-file"));
            }
            Device device = new Device("modality");
            Connection conn = new Connection();
            ApplicationEntity ae = new ApplicationEntity("MODALITY");
            Modality.checkOptions(cl);
            CLIUtils.configureBind((Connection)conn, (ApplicationEntity)ae, (CommandLine)cl);
            CLIUtils.configure((Connection)conn, (CommandLine)cl);
            device.addConnection(conn);
            device.addApplicationEntity(ae);
            ae.addConnection(conn);
            MppsSCU mppsscu = new MppsSCU(ae);
            StoreSCU storescu = new StoreSCU(ae);
            StgCmtSCU stgcmtscu = new StgCmtSCU(ae);
            CLIUtils.configureConnect((Connection)mppsscu.getRemoteConnection(), (AAssociateRQ)mppsscu.getAAssociateRQ(), (CommandLine)cl);
            CLIUtils.configureConnect((Connection)stgcmtscu.getRemoteConnection(), (AAssociateRQ)stgcmtscu.getAAssociateRQ(), (CommandLine)cl);
            CLIUtils.configureConnect((Connection)storescu.getRemoteConnection(), (AAssociateRQ)storescu.getAAssociateRQ(), (CommandLine)cl);
            calledAET = storescu.getAAssociateRQ().getCalledAET();
            mppsscu.setTransferSyntaxes(CLIUtils.transferSyntaxesOf((CommandLine)cl));
            mppsscu.setCodes(CLIUtils.loadProperties((String)cl.getOptionValue("code-config", "resource:code.properties"), null));
            if (cl.hasOption("dc")) {
                mppsscu.setFinalStatus("DISCONTINUED");
            }
            if (cl.hasOption("dc-reason")) {
                mppsscu.setDiscontinuationReason(cl.getOptionValue("dc-reason"));
            }
            stgcmtscu.setTransferSyntaxes(CLIUtils.transferSyntaxesOf((CommandLine)cl));
            stgcmtscu.setStorageDirectory(StgCmtSCU.getStorageDirectory((CommandLine)cl));
            StoreSCU.configureRelatedSOPClass((StoreSCU)storescu, (CommandLine)cl);
            storescu.setUIDSuffix(StoreSCU.uidSuffixOf((CommandLine)cl));
            Attributes attrs = new Attributes();
            CLIUtils.addAttributes((Attributes)attrs, (String[])cl.getOptionValues("s"));
            mppsscu.setAttributes(attrs);
            storescu.setAttributes(attrs);
            stgcmtscu.setAttributes(attrs);
            Modality.setTlsParams(mppsscu.getRemoteConnection(), conn);
            Modality.setTlsParams(storescu.getRemoteConnection(), conn);
            Modality.setTlsParams(stgcmtscu.getRemoteConnection(), conn);
            String tmpPrefix = "iocmtest-";
            String tmpSuffix = null;
            File tmpDir = null;
            Modality.configureTmpFile(storescu, tmpPrefix, tmpSuffix, tmpDir, cl);
            String mppsiuid = UIDUtils.createUID();
            mppsscu.setPPSUID(mppsiuid);
            if (cl.hasOption("kos-title")) {
                List<String> fname = Arrays.asList(Modality.mkkos(cl));
                Modality.scanFiles(fname, tmpPrefix, tmpSuffix, tmpDir, mppsscu, storescu, stgcmtscu);
            } else {
                stgcmtscu.setUIDSuffix(cl.getOptionValue("uid-suffix"));
                storescu.setUIDSuffix(cl.getOptionValue("uid-suffix"));
                mppsscu.setUIDSuffix(cl.getOptionValue("uid-suffix"));
                Modality.scanFiles(cl.getArgList(), tmpPrefix, tmpSuffix, tmpDir, mppsscu, storescu, stgcmtscu);
            }
            ExecutorService executorService = Executors.newCachedThreadPool();
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            device.setExecutor((Executor)executorService);
            device.setScheduledExecutor(scheduledExecutorService);
            device.bindConnections();
            try {
                boolean sendMpps = cl.hasOption("mpps");
                boolean sendLateMpps = cl.hasOption("mpps-late");
                if (sendMpps || sendLateMpps) {
                    Modality.sendMpps(mppsscu, sendMpps);
                    Modality.addReferencedPerformedProcedureStepSequence(mppsiuid, storescu);
                } else {
                    Modality.nullifyReferencedPerformedProcedureStepSequence(storescu);
                }
                Modality.sendObjects(storescu);
                if (sendLateMpps) {
                    Modality.sendMppsNSet(mppsscu);
                }
                if (cl.hasOption("stgcmt")) {
                    Modality.sendStgCmt(stgcmtscu);
                }
            }
            finally {
                if (conn.isListening()) {
                    device.waitForNoOpenConnections();
                    device.unbindConnections();
                }
                executorService.shutdown();
                scheduledExecutorService.shutdown();
            }
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static void checkOptions(CommandLine cl) throws ParseException {
        if (!cl.hasOption("b")) {
            throw new MissingOptionException(CLIUtils.rb.getString("missing-bind-opt"));
        }
        if (!cl.hasOption("c")) {
            throw new MissingOptionException(CLIUtils.rb.getString("missing-connect-opt"));
        }
        if (cl.hasOption("mpps") && cl.hasOption("mpps-late")) {
            throw new ParseException(rb.getString("mpps-error"));
        }
    }

    public static void setTlsParams(Connection remote, Connection conn) {
        remote.setTlsProtocols(conn.getTlsProtocols());
        remote.setTlsCipherSuites(conn.getTlsCipherSuites());
    }

    private static void addReferencedPerformedProcedureStepSequence(String mppsiuid, StoreSCU storescu) {
        Attributes attrs = storescu.getAttributes();
        Sequence seq = attrs.newSequence(528657, 1);
        Attributes item = new Attributes(2);
        item.setString(528720, VR.UI, "1.2.840.10008.3.1.2.3.3");
        item.setString(528725, VR.UI, mppsiuid);
        seq.add(item);
    }

    private static void nullifyReferencedPerformedProcedureStepSequence(StoreSCU storescu) {
        Attributes attrs = storescu.getAttributes();
        attrs.setNull(528657, VR.SQ);
    }

    private static String mkkos(CommandLine cl) throws Exception {
        Modality.printNextStepMessage("Will now generate a Key Object for files in " + cl.getArgList());
        final MkKOS mkkos = new MkKOS();
        mkkos.setUIDSuffix(cl.getOptionValue("uid-suffix"));
        mkkos.setCodes(CLIUtils.loadProperties((String)cl.getOptionValue("code-config", "resource:code.properties"), null));
        mkkos.setDocumentTitle(mkkos.toCodeItem(Modality.documentTitleOf(cl)));
        mkkos.setKeyObjectDescription(cl.getOptionValue("desc"));
        mkkos.setSeriesNumber(cl.getOptionValue("series-no", "999"));
        mkkos.setInstanceNumber(cl.getOptionValue("inst-no", "1"));
        mkkos.setOutputFile(MkKOS.outputFileOf((CommandLine)cl));
        mkkos.setNoFileMetaInformation(cl.hasOption("F"));
        mkkos.setTransferSyntax(cl.getOptionValue("t", "1.2.840.10008.1.2.1"));
        mkkos.setEncodingOptions(CLIUtils.encodingOptionsOf((CommandLine)cl));
        DicomFiles.scan((List)cl.getArgList(), (DicomFiles.Callback)new DicomFiles.Callback(){

            public boolean dicomFile(File f, Attributes fmi, long dsPos, Attributes ds) {
                return mkkos.addInstance(ds);
            }
        });
        System.out.println();
        mkkos.writeKOS();
        System.out.println(MessageFormat.format(rb.getString("stored"), mkkos.getFname()));
        return mkkos.getFname();
    }

    private static String documentTitleOf(CommandLine cl) throws MissingOptionException {
        if (!cl.hasOption("kos-title")) {
            throw new MissingOptionException(rb.getString("missing-title"));
        }
        return cl.getOptionValue("kos-title");
    }

    private static void sendStgCmt(StgCmtSCU stgcmtscu) throws IOException, InterruptedException, IncompatibleConnectionException, GeneralSecurityException {
        Modality.printNextStepMessage("Will now send Storage Commitment to " + calledAET);
        try {
            stgcmtscu.open();
            stgcmtscu.sendRequests();
        }
        finally {
            stgcmtscu.close();
        }
    }

    private static void sendMpps(MppsSCU mppsscu, boolean sendNSet) throws IOException, InterruptedException, IncompatibleConnectionException, GeneralSecurityException {
        try {
            Modality.printNextStepMessage("Will now send MPPS N-CREATE to " + calledAET);
            mppsscu.open();
            mppsscu.createMpps();
            if (sendNSet) {
                Modality.printNextStepMessage("Will now send MPPS N-SET to " + calledAET);
                mppsscu.updateMpps();
            }
        }
        finally {
            mppsscu.close();
        }
    }

    private static void sendMppsNSet(MppsSCU mppsscu) throws IOException, InterruptedException, IncompatibleConnectionException, GeneralSecurityException {
        try {
            Modality.printNextStepMessage("Will now send MPPS N-SET to " + calledAET);
            mppsscu.open();
            mppsscu.updateMpps();
        }
        finally {
            mppsscu.close();
        }
    }

    private static void printNextStepMessage(String message) throws IOException {
        System.out.println("===========================================================");
        System.out.println(message + ". Press <enter> to continue.");
        System.out.println("===========================================================");
        bufferedReader.read();
    }

    private static void sendObjects(StoreSCU storescu) throws IOException, InterruptedException, IncompatibleConnectionException, GeneralSecurityException {
        Modality.printNextStepMessage("Will now send DICOM object(s) to " + calledAET);
        try {
            storescu.open();
            storescu.sendFiles();
        }
        finally {
            storescu.close();
        }
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addTransferSyntaxOptions((Options)opts);
        CLIUtils.addConnectOption((Options)opts);
        CLIUtils.addAEOptions((Options)opts);
        CLIUtils.addSendTimeoutOption((Options)opts);
        CLIUtils.addStoreTimeoutOption((Options)opts);
        CLIUtils.addResponseTimeoutOption((Options)opts);
        CLIUtils.addCommonOptions((Options)opts);
        CLIUtils.addBindOption((Options)opts, (String)"IOCMTEST");
        StoreSCU.addTmpFileOptions((Options)opts);
        StoreSCU.addUIDSuffixOption((Options)opts);
        Modality.addOptions(opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, Modality.class);
    }

    private static void addOptions(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("code-value").desc(rb.getString("kos-title")).longOpt("kos-title").build());
        opts.addOption(Option.builder((String)"o").hasArg().argName("file").desc(rb.getString("o-file")).build());
        opts.addOption(Option.builder().hasArg().argName("file").desc(rb.getString("code-config")).longOpt("code-config").build());
        OptionGroup mpps = new OptionGroup();
        mpps.addOption(Option.builder().desc(rb.getString("mpps-late")).longOpt("mpps-late").build());
        mpps.addOption(Option.builder().desc(rb.getString("mpps")).longOpt("mpps").build());
        opts.addOptionGroup(mpps);
        opts.addOption(Option.builder().desc(rb.getString("stgcmt")).longOpt("stgcmt").build());
        opts.addOption(null, "dc", false, rb.getString("dc"));
        opts.addOption(Option.builder().hasArg().argName("code-value").desc(rb.getString("dc-reason")).longOpt("dc-reason").build());
        opts.addOption(Option.builder((String)"s").hasArgs().argName("[seq.]attr=value").desc(rb.getString("set")).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scanFiles(List<String> fnames, String tmpPrefix, String tmpSuffix, File tmpDir, final MppsSCU mppsscu, final StoreSCU storescu, final StgCmtSCU stgcmtscu) throws IOException {
        Modality.printNextStepMessage("Will now scan files in " + fnames);
        File tmpFile = File.createTempFile(tmpPrefix, tmpSuffix, tmpDir);
        tmpFile.deleteOnExit();
        try (final BufferedWriter fileInfos = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(tmpFile)));){
            DicomFiles.scan(fnames, (DicomFiles.Callback)new DicomFiles.Callback(){

                public boolean dicomFile(File f, Attributes fmi, long dsPos, Attributes ds) throws Exception {
                    return mppsscu.addInstance(ds) && storescu.addFile(fileInfos, f, dsPos, fmi, ds) && stgcmtscu.addInstance(ds);
                }
            });
            storescu.setTmpFile(tmpFile);
        }
        System.out.println(" Done");
    }

    private static void configureTmpFile(StoreSCU storescu, String tmpPrefix, String tmpSuffix, File tmpDir, CommandLine cl) {
        if (cl.hasOption("tmp-file-dir")) {
            tmpDir = new File(cl.getOptionValue("tmp-file-dir"));
            storescu.setTmpFileDirectory(tmpDir);
        }
        tmpPrefix = cl.getOptionValue("tmp-file-prefix", "iocmtest-");
        storescu.setTmpFilePrefix(tmpPrefix);
        tmpSuffix = cl.getOptionValue("tmp-file-suffix");
        storescu.setTmpFileSuffix(tmpSuffix);
    }
}

