/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.jpg2dcm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.VR;
import org.dcm4che3.imageio.codec.XPEGParser;
import org.dcm4che3.imageio.codec.jpeg.JPEGParser;
import org.dcm4che3.imageio.codec.mp4.MP4Parser;
import org.dcm4che3.imageio.codec.mpeg.MPEG2Parser;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.io.SAXReader;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.StreamUtils;
import org.dcm4che3.util.UIDUtils;
import org.xml.sax.SAXException;

public class Jpg2Dcm {
    private static final int BUFFER_SIZE = 8162;
    private static final ElementDictionary DICT = ElementDictionary.getStandardElementDictionary();
    private static final ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.jpg2dcm.messages");
    private static final int[] IUID_TAGS = new int[]{0x20000D, 0x20000E, 524312};
    private static final int[] TYPE2_TAGS = new int[]{524323, 524339};
    private boolean noAPPn;
    private boolean photo;
    private String tsuid;
    private ContentType contentType;
    private long fragmentLength = 0xFFFFFFFEL;
    private Attributes staticMetadata = new Attributes();
    private byte[] buf = new byte[8162];

    private void setNoAPPn(boolean noAPPn) {
        this.noAPPn = noAPPn;
    }

    private void setPhoto(boolean photo) {
        this.photo = photo;
    }

    private void setTSUID(String tsuid) {
        this.tsuid = tsuid;
    }

    public void setContentType(String s) {
        ContentType contentType = ContentType.of(s);
        if (contentType == null) {
            throw new IllegalArgumentException(MessageFormat.format(rb.getString("unsupported-content-type"), s));
        }
        this.contentType = contentType;
    }

    public void setFragmentLength(long fragmentLength) {
        if (fragmentLength < 1024L || fragmentLength > 0xFFFFFFFEL) {
            throw new IllegalArgumentException("Maximal Fragment Length must be in the range of [1024, 4294967294].");
        }
        this.fragmentLength = fragmentLength & 0xFFFFFFFFFFFFFFFEL;
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = Jpg2Dcm.parseComandLine(args);
            Jpg2Dcm main = new Jpg2Dcm();
            List argList = cl.getArgList();
            int argc = argList.size();
            if (argc < 2) {
                throw new ParseException(rb.getString("missing"));
            }
            File dest = new File((String)argList.get(argc - 1));
            if ((argc > 2 || new File((String)argList.get(0)).isDirectory()) && !dest.isDirectory()) {
                throw new ParseException(MessageFormat.format(rb.getString("nodestdir"), dest));
            }
            main.setNoAPPn(cl.hasOption("no-app"));
            main.setPhoto(cl.hasOption("xc"));
            main.setTSUID(cl.getOptionValue("tsuid"));
            if (cl.hasOption("content-type")) {
                main.setContentType(cl.getOptionValue("content-type"));
            }
            if (cl.hasOption("F")) {
                main.setFragmentLength(Long.parseLong(cl.getOptionValue("F")));
            }
            Jpg2Dcm.createStaticMetadata(cl, main.staticMetadata);
            main.convert(cl.getArgList());
        }
        catch (ParseException e) {
            System.err.println("jpg2dcm: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("jpg2dcm: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        opts.addOption(Option.builder((String)"s").hasArgs().argName("[seq.]attr=value").desc(rb.getString("metadata")).build());
        opts.addOption(Option.builder((String)"f").hasArg().argName("xml-file").desc(rb.getString("file")).build());
        opts.addOption(Option.builder().longOpt("xc").hasArg(false).desc(rb.getString("xc")).build());
        opts.addOption(Option.builder().longOpt("tsuid").hasArg().argName("uid").desc(rb.getString("tsuid")).build());
        opts.addOption(Option.builder().longOpt("content-type").hasArg().argName("type").desc(rb.getString("content-type")).build());
        opts.addOption(Option.builder().longOpt("no-app").hasArg(false).desc(rb.getString("no-app")).build());
        opts.addOption(Option.builder((String)"F").longOpt("fragment").hasArg().argName("length").desc(rb.getString("fragment")).build());
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, Jpg2Dcm.class);
    }

    private static void createStaticMetadata(CommandLine cl, Attributes staticMetadata) throws Exception {
        if (cl.hasOption("f")) {
            SAXReader.parse((String)cl.getOptionValue("f"), (Attributes)staticMetadata);
        }
        CLIUtils.addAttributes((Attributes)staticMetadata, (String[])cl.getOptionValues("s"));
        Jpg2Dcm.supplementMissingUIDs(staticMetadata);
        Jpg2Dcm.supplementMissingValue(staticMetadata, 0x200011, "999");
        Jpg2Dcm.supplementMissingValue(staticMetadata, 2097171, "1");
        Jpg2Dcm.supplementType2Tags(staticMetadata);
    }

    private void convert(List<String> args) throws Exception {
        int argsSize = args.size();
        Path destPath = Paths.get(args.get(argsSize - 1), new String[0]);
        for (String src : args.subList(0, argsSize - 1)) {
            Path srcPath = Paths.get(src, new String[0]);
            if (Files.isDirectory(srcPath, new LinkOption[0])) {
                Files.walkFileTree(srcPath, new Jpg2DcmFileVisitor(srcPath, destPath));
                continue;
            }
            if (Files.isDirectory(destPath, new LinkOption[0])) {
                this.convert(srcPath, destPath.resolve(srcPath.getFileName() + ".dcm"));
                continue;
            }
            this.convert(srcPath, destPath);
        }
    }

    private void convert(Path srcFilePath, Path destFilePath) throws Exception {
        ContentType contentType = this.contentType;
        if (contentType == null) {
            String probeContentType = Files.probeContentType(srcFilePath);
            if (probeContentType == null) {
                System.out.println(MessageFormat.format(rb.getString("probe-content-type-failed"), srcFilePath));
                return;
            }
            contentType = ContentType.of(probeContentType);
            if (contentType == null) {
                System.out.println(MessageFormat.format(rb.getString("unsupported-content-type-of-file"), probeContentType, srcFilePath));
                return;
            }
        }
        Attributes fileMetadata = SAXReader.parse((InputStream)StreamUtils.openFileOrURL((String)contentType.getSampleMetadataFile(this.photo)));
        fileMetadata.addAll(this.staticMetadata);
        Jpg2Dcm.supplementMissingValue(fileMetadata, 524310, contentType.getSOPClassUID(this.photo));
        try (SeekableByteChannel channel = Files.newByteChannel(srcFilePath, new OpenOption[0]);
             DicomOutputStream dos = new DicomOutputStream(destFilePath.toFile());){
            long len;
            XPEGParser parser = contentType.newParser(channel);
            parser.getAttributes(fileMetadata);
            byte[] prefix = ByteUtils.EMPTY_BYTES;
            if (this.noAPPn && parser.getPositionAfterAPPSegments() > 0L) {
                channel.position(parser.getPositionAfterAPPSegments());
                prefix = new byte[]{-1, -40};
            } else {
                channel.position(parser.getCodeStreamPosition());
            }
            long codeStreamSize = channel.size() - channel.position() + (long)prefix.length;
            dos.writeDataset(fileMetadata.createFileMetaInformation(this.tsuid != null ? this.tsuid : parser.getTransferSyntaxUID(codeStreamSize > this.fragmentLength)), fileMetadata);
            dos.writeHeader(2145386512, VR.OB, -1);
            dos.writeHeader(-73728, null, 0);
            do {
                len = Math.min(codeStreamSize, this.fragmentLength);
                dos.writeHeader(-73728, null, (int)(len + 1L & 0xFFFFFFFFFFFFFFFEL));
                dos.write(prefix);
                this.copy(channel, len - (long)prefix.length, (OutputStream)dos);
                if ((len & 1L) != 0L) {
                    dos.write(0);
                }
                prefix = ByteUtils.EMPTY_BYTES;
            } while ((codeStreamSize -= len) > 0L);
            dos.writeHeader(-73507, null, 0);
        }
        System.out.println(MessageFormat.format(rb.getString("converted"), srcFilePath, destFilePath));
    }

    private void copy(ByteChannel in, long len, OutputStream out) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(this.buf);
        while (len > 0L) {
            bb.position(0);
            bb.limit((int)Math.min(len, (long)this.buf.length));
            int read = in.read(bb);
            out.write(this.buf, 0, read);
            len -= (long)read;
        }
    }

    private static void supplementMissingUIDs(Attributes metadata) {
        for (int tag : IUID_TAGS) {
            if (metadata.containsValue(tag)) continue;
            metadata.setString(tag, VR.UI, UIDUtils.createUID());
        }
    }

    private static void supplementMissingValue(Attributes metadata, int tag, String value) {
        if (!metadata.containsValue(tag)) {
            metadata.setString(tag, DICT.vrOf(tag), value);
        }
    }

    private static void supplementType2Tags(Attributes metadata) {
        for (int tag : TYPE2_TAGS) {
            if (metadata.contains(tag)) continue;
            metadata.setNull(tag, DICT.vrOf(tag));
        }
    }

    private static enum ContentType {
        IMAGE_JPEG{

            @Override
            String getSampleMetadataFile(boolean photo) {
                return photo ? "resource:vlPhotographicImageMetadata.xml" : "resource:secondaryCaptureImageMetadata.xml";
            }

            @Override
            String getSOPClassUID(boolean photo) {
                return photo ? "1.2.840.10008.5.1.4.1.1.77.1.4" : "1.2.840.10008.5.1.4.1.1.7";
            }

            @Override
            XPEGParser newParser(SeekableByteChannel channel) throws IOException {
                return new JPEGParser(channel);
            }
        }
        ,
        VIDEO_MPEG{

            @Override
            XPEGParser newParser(SeekableByteChannel channel) throws IOException {
                return new MPEG2Parser(channel);
            }
        }
        ,
        VIDEO_MP4{

            @Override
            XPEGParser newParser(SeekableByteChannel channel) throws IOException {
                return new MP4Parser(channel);
            }
        };


        static ContentType of(String type) {
            switch (type.toLowerCase()) {
                case "image/jpeg": 
                case "image/jp2": 
                case "image/j2c": 
                case "image/jph": 
                case "image/jphc": {
                    return IMAGE_JPEG;
                }
                case "video/mpeg": {
                    return VIDEO_MPEG;
                }
                case "video/mp4": 
                case "video/quicktime": {
                    return VIDEO_MP4;
                }
            }
            return null;
        }

        String getSampleMetadataFile(boolean photo) {
            return "resource:vlPhotographicImageMetadata.xml";
        }

        String getSOPClassUID(boolean photo) {
            return "1.2.840.10008.5.1.4.1.1.77.1.4.1";
        }

        abstract XPEGParser newParser(SeekableByteChannel var1) throws IOException;
    }

    class Jpg2DcmFileVisitor
    extends SimpleFileVisitor<Path> {
        private Path srcPath;
        private Path destPath;

        Jpg2DcmFileVisitor(Path srcPath, Path destPath) {
            this.srcPath = srcPath;
            this.destPath = destPath;
        }

        @Override
        public FileVisitResult visitFile(Path srcFilePath, BasicFileAttributes attrs) throws IOException {
            Path destFilePath = this.resolveDestFilePath(srcFilePath);
            if (!Files.isDirectory(destFilePath, new LinkOption[0])) {
                Files.createDirectories(destFilePath, new FileAttribute[0]);
            }
            try {
                Jpg2Dcm.this.convert(srcFilePath, destFilePath.resolve(srcFilePath.getFileName() + ".dcm"));
            }
            catch (ParserConfigurationException | SAXException e) {
                System.out.println(MessageFormat.format(rb.getString("failed"), srcFilePath, e.getMessage()));
                e.printStackTrace(System.out);
                return FileVisitResult.TERMINATE;
            }
            catch (Exception e) {
                System.out.println(MessageFormat.format(rb.getString("failed"), srcFilePath, e.getMessage()));
                e.printStackTrace(System.out);
            }
            return FileVisitResult.CONTINUE;
        }

        private Path resolveDestFilePath(Path srcFilePath) {
            int srcFilePathNameCount;
            int srcPathNameCount = this.srcPath.getNameCount();
            if (srcPathNameCount == (srcFilePathNameCount = srcFilePath.getNameCount() - 1)) {
                return this.destPath;
            }
            return this.destPath.resolve(srcFilePath.subpath(srcPathNameCount, srcFilePathNameCount));
        }
    }
}

