/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.json2dcm;

import jakarta.json.Json;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.BasicBulkDataDescriptor;
import org.dcm4che3.io.BulkDataDescriptor;
import org.dcm4che3.io.DicomEncodingOptions;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.json.JSONReader;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.SafeClose;

public class Json2Dcm {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.json2dcm.messages");
    private DicomInputStream.IncludeBulkData includeBulkData = DicomInputStream.IncludeBulkData.URI;
    private boolean catBlkFiles = false;
    private String blkFilePrefix = "blk";
    private String blkFileSuffix;
    private File blkDirectory;
    private BasicBulkDataDescriptor bulkDataDescriptor = new BasicBulkDataDescriptor();
    private String tsuid;
    private boolean withfmi;
    private boolean nofmi;
    private DicomEncodingOptions encOpts = DicomEncodingOptions.DEFAULT;
    private List<File> bulkDataFiles;
    private Attributes fmi;
    private Attributes dataset;

    public final void setIncludeBulkData(DicomInputStream.IncludeBulkData includeBulkData) {
        this.includeBulkData = includeBulkData;
    }

    public final void setConcatenateBulkDataFiles(boolean catBlkFiles) {
        this.catBlkFiles = catBlkFiles;
    }

    public final void setBulkDataFilePrefix(String blkFilePrefix) {
        this.blkFilePrefix = blkFilePrefix;
    }

    public final void setBulkDataFileSuffix(String blkFileSuffix) {
        this.blkFileSuffix = blkFileSuffix;
    }

    public final void setBulkDataDirectory(File blkDirectory) {
        this.blkDirectory = blkDirectory;
    }

    public void setBulkDataNoDefaults(boolean excludeDefaults) {
        this.bulkDataDescriptor.excludeDefaults(excludeDefaults);
    }

    public void setBulkDataLengthsThresholdsFromStrings(String[] thresholds) {
        this.bulkDataDescriptor.setLengthsThresholdsFromStrings(thresholds);
    }

    public final void setTransferSyntax(String uid) {
        this.tsuid = uid;
    }

    public final void setWithFileMetaInformation(boolean withfmi) {
        this.withfmi = withfmi;
    }

    public final void setNoFileMetaInformation(boolean nofmi) {
        this.nofmi = nofmi;
    }

    public final void setEncodingOptions(DicomEncodingOptions encOpts) {
        this.encOpts = encOpts;
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        Json2Dcm.addIOFileNameOptions(opts);
        Json2Dcm.addBulkdataOptions(opts);
        Json2Dcm.addFileEncodingOptions(opts);
        CommandLine cl = CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, Json2Dcm.class);
        if (!cl.hasOption("j") && !cl.hasOption("i")) {
            throw new ParseException(rb.getString("missing-i-j"));
        }
        return cl;
    }

    private static void addIOFileNameOptions(Options opts) {
        opts.addOption(Option.builder((String)"j").hasArg().argName("json-file").desc(rb.getString("j-file")).build());
        opts.addOption(Option.builder((String)"i").hasArg().argName("dicom-file").desc(rb.getString("i-file")).build());
        opts.addOption(Option.builder((String)"o").hasArg().argName("dicom-file").desc(rb.getString("o-file")).build());
    }

    private static void addBulkdataOptions(Options opts) {
        OptionGroup blkGroup = new OptionGroup();
        blkGroup.addOption(Option.builder((String)"B").longOpt("no-bulkdata").desc(rb.getString("no-bulkdata")).build());
        blkGroup.addOption(Option.builder((String)"b").longOpt("alloc-bulkdata").desc(rb.getString("alloc-bulkdata")).build());
        opts.addOptionGroup(blkGroup);
        opts.addOption(Option.builder((String)"d").longOpt("blk-file-dir").hasArg().argName("directory").desc(rb.getString("blk-file-dir")).build());
        opts.addOption(Option.builder().longOpt("blk-file-prefix").hasArg().argName("prefix").desc(rb.getString("blk-file-prefix")).build());
        opts.addOption(Option.builder().longOpt("blk-file-suffix").hasArg().argName("suffix").desc(rb.getString("blk-file-suffix")).build());
        opts.addOption("c", "cat-blk-files", false, rb.getString("cat-blk-files"));
        opts.addOption(null, "keep-blk-files", false, rb.getString("keep-blk-files"));
        opts.addOption(null, "blk-nodefs", false, rb.getString("blk-nodefs"));
        opts.addOption(Option.builder(null).longOpt("blk").hasArgs().argName("[seq.]attr").desc(rb.getString("blk")).build());
        opts.addOption(Option.builder(null).longOpt("blk-vr").hasArgs().argName("vr[,...]=length").desc(rb.getString("blk-vr")).build());
    }

    private static void addFileEncodingOptions(Options opts) {
        opts.addOption(Option.builder((String)"t").longOpt("transfer-syntax").hasArg().argName("uid").desc(rb.getString("transfer-syntax")).build());
        OptionGroup fmiGroup = new OptionGroup();
        fmiGroup.addOption(Option.builder((String)"F").longOpt("no-fmi").desc(rb.getString("no-fmi")).build());
        fmiGroup.addOption(Option.builder((String)"f").longOpt("fmi").desc(rb.getString("fmi")).build());
        opts.addOptionGroup(fmiGroup);
        CLIUtils.addEncodingOptions((Options)opts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            CommandLine cl = Json2Dcm.parseComandLine(args);
            Json2Dcm main = new Json2Dcm();
            Json2Dcm.configureBulkdata(main, cl);
            if (cl.hasOption("t")) {
                main.setTransferSyntax(cl.getOptionValue("t"));
            }
            main.setWithFileMetaInformation(cl.hasOption("f"));
            main.setNoFileMetaInformation(cl.hasOption("F"));
            main.setEncodingOptions(CLIUtils.encodingOptionsOf((CommandLine)cl));
            try {
                if (cl.hasOption("i")) {
                    String fname = cl.getOptionValue("i");
                    if (fname.equals("-")) {
                        main.parse(new DicomInputStream(System.in));
                    } else {
                        try (DicomInputStream dis = new DicomInputStream(new File(fname));){
                            main.parse(dis);
                        }
                    }
                }
                if (cl.hasOption("j")) {
                    main.mergeJSON(cl.getOptionValue("j"));
                }
                try (FileOutputStream out = cl.hasOption("o") ? new FileOutputStream(cl.getOptionValue("o")) : new FileOutputStream(FileDescriptor.out);){
                    main.writeTo(out);
                }
            }
            finally {
                if (!cl.hasOption("keep-blk-files")) {
                    main.delBulkDataFiles();
                }
            }
        }
        catch (ParseException e) {
            System.err.println("json2dcm: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("json2dcm: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static void configureBulkdata(Json2Dcm json2dcm, CommandLine cl) throws Exception {
        if (cl.hasOption("b")) {
            json2dcm.setIncludeBulkData(DicomInputStream.IncludeBulkData.YES);
        }
        if (cl.hasOption("B")) {
            json2dcm.setIncludeBulkData(DicomInputStream.IncludeBulkData.NO);
        }
        if (cl.hasOption("blk-file-prefix")) {
            json2dcm.setBulkDataFilePrefix(cl.getOptionValue("blk-file-prefix"));
        }
        if (cl.hasOption("blk-file-suffix")) {
            json2dcm.setBulkDataFileSuffix(cl.getOptionValue("blk-file-suffix"));
        }
        if (cl.hasOption("d")) {
            File tempDir = new File(cl.getOptionValue("d"));
            json2dcm.setBulkDataDirectory(tempDir);
        }
        json2dcm.setConcatenateBulkDataFiles(cl.hasOption("c"));
        json2dcm.setBulkDataNoDefaults(cl.hasOption("blk-nodefs"));
        if (cl.hasOption("blk")) {
            CLIUtils.addTagPaths((BasicBulkDataDescriptor)json2dcm.bulkDataDescriptor, (String[])cl.getOptionValues("blk"));
        }
        if (cl.hasOption("blk-vr")) {
            json2dcm.setBulkDataLengthsThresholdsFromStrings(cl.getOptionValues("blk-vr"));
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this.nofmi) {
            this.fmi = null;
        } else if (this.fmi == null ? this.withfmi : this.tsuid != null && !this.tsuid.equals(this.fmi.getString(131088, null))) {
            this.fmi = this.dataset.createFileMetaInformation(this.tsuid);
        }
        DicomOutputStream dos = new DicomOutputStream((OutputStream)new BufferedOutputStream(out), this.fmi != null ? "1.2.840.10008.1.2.1" : (this.tsuid != null ? this.tsuid : "1.2.840.10008.1.2"));
        dos.setEncodingOptions(this.encOpts);
        dos.writeDataset(this.fmi, this.dataset);
        dos.finish();
        dos.flush();
    }

    public void delBulkDataFiles() {
        if (this.bulkDataFiles != null) {
            for (File f : this.bulkDataFiles) {
                f.delete();
            }
        }
    }

    public void parse(DicomInputStream dis) throws IOException {
        dis.setIncludeBulkData(this.includeBulkData);
        dis.setBulkDataDescriptor((BulkDataDescriptor)this.bulkDataDescriptor);
        dis.setBulkDataDirectory(this.blkDirectory);
        dis.setBulkDataFilePrefix(this.blkFilePrefix);
        dis.setBulkDataFileSuffix(this.blkFileSuffix);
        dis.setConcatenateBulkDataFiles(this.catBlkFiles);
        this.dataset = dis.readDataset();
        this.fmi = dis.getFileMetaInformation();
        this.bulkDataFiles = dis.getBulkDataFiles();
    }

    public void mergeJSON(String fname) throws Exception {
        JSONReader reader;
        Attributes fmi2;
        if (this.dataset == null) {
            this.dataset = new Attributes();
        }
        if ((fmi2 = (reader = Json2Dcm.parseJSON(fname, this.dataset)).getFileMetaInformation()) != null) {
            if (this.fmi != null) {
                this.fmi.addAll(fmi2);
            } else {
                this.fmi = fmi2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONReader parseJSON(String fname, Attributes attrs) throws IOException {
        InputStream in = fname.equals("-") ? System.in : new FileInputStream(fname);
        try {
            JSONReader reader = new JSONReader(Json.createParser((Reader)new InputStreamReader(in, "UTF-8")));
            reader.readDataset(attrs);
            JSONReader jSONReader = reader;
            return jSONReader;
        }
        finally {
            if (in != System.in) {
                SafeClose.close((Closeable)in);
            }
        }
    }
}

