/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.json2props;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.tool.common.CLIUtils;

public class Json2Props {
    private static final ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.json2props.messages");
    private final File schemaDir;
    private final File propsDir;

    public Json2Props(File schemaDir, File propsDir) {
        this.schemaDir = schemaDir;
        this.propsDir = propsDir;
    }

    private static CommandLine parseCommandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, Json2Props.class);
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = Json2Props.parseCommandLine(args);
            List argsList = cl.getArgList();
            switch (argsList.size()) {
                case 0: 
                case 1: {
                    throw new ParseException(rb.getString("missing-args"));
                }
                case 2: {
                    Json2Props.json2props(new File((String)argsList.get(0)), new File((String)argsList.get(1)));
                    break;
                }
                case 3: {
                    Json2Props.props2json(new File((String)argsList.get(0)), new File((String)argsList.get(1)), new File((String)argsList.get(2)));
                    break;
                }
                default: {
                    throw new ParseException(rb.getString("to-many-args"));
                }
            }
        }
        catch (ParseException e) {
            System.err.println("json2props: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("json2props: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    public static void json2props(File schemaDir, File propsDir) throws IOException {
        String[] fnames = schemaDir.list((dir, name) -> name.endsWith(".schema.json"));
        if (fnames == null || fnames.length == 0) {
            System.err.println("No schema files found in " + schemaDir);
            System.err.println(rb.getString("try"));
            return;
        }
        propsDir.mkdirs();
        for (String fname : fnames) {
            String prefix = fname.substring(0, fname.length() - 11);
            Json2Props.json2props1(new File(schemaDir, fname), new File(propsDir, prefix + "props"), prefix);
        }
    }

    private static void json2props1(File inFile, File outFile, String prefix) throws IOException {
        System.out.println(inFile.toString() + "=>" + outFile.toString());
        try (JsonReader reader = Json.createReader((Reader)new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(inFile)), StandardCharsets.UTF_8));
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outFile)), StandardCharsets.UTF_8);){
            JsonObject doc = reader.readObject();
            JsonObject properties = doc.getJsonObject("properties");
            writer.write(prefix.substring(0, prefix.length() - 1));
            ((Writer)writer).write(58);
            writer.write(doc.getString("title"));
            ((Writer)writer).write(124);
            writer.write(doc.getString("description").replace("\\", "\\\\"));
            ((Writer)writer).write(13);
            ((Writer)writer).write(10);
            for (String name : properties.keySet()) {
                JsonObject property = properties.getJsonObject(name);
                writer.write(prefix);
                writer.write(name);
                ((Writer)writer).write(58);
                writer.write(property.getString("title"));
                ((Writer)writer).write(124);
                writer.write(property.getString("description").replace("\\", "\\\\"));
                ((Writer)writer).write(13);
                ((Writer)writer).write(10);
            }
        }
    }

    public static void props2json(File srcSchemaDir, File propsDir, File destSchemaDir) throws IOException {
        String[] fnames = srcSchemaDir.list((dir, name) -> name.endsWith(".schema.json"));
        if (fnames == null || fnames.length == 0) {
            System.err.println("No schema files found in " + srcSchemaDir);
            System.err.println(rb.getString("try"));
            return;
        }
        destSchemaDir.mkdirs();
        for (String fname : fnames) {
            String prefix = fname.substring(0, fname.length() - 11);
            Json2Props.props2json1(new File(srcSchemaDir, fname), new File(propsDir, prefix + "props"), new File(destSchemaDir, fname), prefix);
        }
    }

    private static void props2json1(File schemaFile, File propsFile, File outFile, String prefix) throws IOException {
        System.out.println(propsFile.toString() + "=>" + outFile.toString());
        Properties props = new Properties();
        try (BufferedReader reader12 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(propsFile), StandardCharsets.UTF_8));){
            props.load(reader12);
        }
        catch (FileNotFoundException reader12) {
            // empty catch block
        }
        ArrayList<String> invalidProperties = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(schemaFile), StandardCharsets.UTF_8));
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), StandardCharsets.UTF_8));){
            String line;
            String indent = "  ";
            int endTitle = -1;
            int field = 3;
            int fieldAfterDescription = 3;
            String key2 = prefix.substring(0, prefix.length() - 1);
            String value = props.getProperty(key2);
            if (value != null) {
                endTitle = value.indexOf(124);
                if (endTitle > 0) {
                    field = 0;
                } else {
                    invalidProperties.add(key2);
                }
            }
            while ((line = reader.readLine()) != null) {
                switch (field) {
                    case 0: {
                        field = 1;
                        break;
                    }
                    case 1: {
                        line = indent + "\"title\": \"" + value.substring(0, endTitle).trim() + "\",";
                        field = 2;
                        break;
                    }
                    case 2: {
                        line = indent + "\"description\": \"" + value.substring(endTitle + 1).trim().replace("\\", "\\\\").replace("\"", "\\\"") + "\",";
                        field = fieldAfterDescription;
                        break;
                    }
                    case 3: {
                        if (!line.startsWith("  \"properties\"")) break;
                        field = 4;
                        indent = "      ";
                        fieldAfterDescription = 4;
                        break;
                    }
                    case 4: {
                        if (!line.startsWith("    \"") || (value = props.getProperty(key2 = prefix + line.substring(5, line.length() - 4))) == null) break;
                        endTitle = value.indexOf(124);
                        if (endTitle > 0) {
                            field = 1;
                            break;
                        }
                        invalidProperties.add(key2);
                    }
                }
                writer.write(line);
                writer.write(10);
            }
        }
        if (!invalidProperties.isEmpty()) {
            System.out.printf("IGNORED %d PROPERTIES WITH MISSING |:%n", invalidProperties.size());
            invalidProperties.forEach(key -> System.out.printf("%s:%s%n", key, props.get(key)));
        }
    }
}

