/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.mkkos;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomEncodingOptions;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.tool.common.DicomFiles;
import org.dcm4che3.util.UIDUtils;

public class MkKOS {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.mkkos.messages");
    private static final int[] PATIENT_AND_STUDY_ATTRS = new int[]{524293, 524320, 524336, 524368, 524369, 524432, 0x100010, 0x100020, 0x100021, 0x100030, 0x100040, 0x20000D, 0x200010};
    private final Attributes attrs = new Attributes();
    private String uidSuffix;
    private String fname;
    private boolean nofmi;
    private DicomEncodingOptions encOpts;
    private String tsuid;
    private String seriesNumber;
    private String instanceNumber;
    private String keyObjectDescription;
    private String retrieveAET;
    private String retrieveURL;
    private String locationUID;
    private Attributes documentTitle;
    private Attributes documentTitleModifier;
    private Properties codes;
    private Attributes kos;
    private Sequence evidenceSeq;
    private Sequence contentSeq;

    public String getFname() {
        return this.fname;
    }

    public final void setUIDSuffix(String uidSuffix) {
        this.uidSuffix = uidSuffix;
    }

    public void setOutputFile(String fname) {
        this.fname = fname;
    }

    public void setNoFileMetaInformation(boolean nofmi) {
        this.nofmi = nofmi;
    }

    public final void setEncodingOptions(DicomEncodingOptions encOpts) {
        this.encOpts = encOpts;
    }

    public final void setTransferSyntax(String tsuid) {
        this.tsuid = tsuid;
    }

    public final void setSeriesNumber(String seriesNumber) {
        this.seriesNumber = seriesNumber;
    }

    public final void setInstanceNumber(String instanceNumber) {
        this.instanceNumber = instanceNumber;
    }

    public final void setKeyObjectDescription(String keyObjectDescription) {
        this.keyObjectDescription = keyObjectDescription;
    }

    public void setRetrieveAET(String retrieveAET) {
        this.retrieveAET = retrieveAET;
    }

    public void setRetrieveURL(String retrieveURL) {
        this.retrieveURL = retrieveURL;
    }

    public void setLocationUID(String locationUID) {
        this.locationUID = locationUID;
    }

    public final void setCodes(Properties codes) {
        this.codes = codes;
    }

    public final void setDocumentTitle(Attributes codeItem) {
        this.documentTitle = codeItem;
    }

    public final void setDocumentTitleModifier(Attributes codeItem) {
        this.documentTitleModifier = codeItem;
    }

    public static void main(String[] args) throws Exception {
        try {
            CommandLine cl = MkKOS.parseComandLine(args);
            final MkKOS main = new MkKOS();
            MkKOS.configure(main, cl);
            System.out.println(rb.getString("scanning"));
            DicomFiles.scan((List)cl.getArgList(), (DicomFiles.Callback)new DicomFiles.Callback(){

                public boolean dicomFile(File f, Attributes fmi, long dsPos, Attributes ds) {
                    return main.addInstance(ds);
                }
            });
            System.out.println();
            main.writeKOS();
            System.out.println(MessageFormat.format(rb.getString("stored"), main.fname));
        }
        catch (ParseException e) {
            System.err.println("mkkos: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        MkKOS.addOptions(opts);
        CommandLine cl = CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, MkKOS.class);
        if (cl.getArgList().isEmpty()) {
            throw new ParseException(rb.getString("missing"));
        }
        return cl;
    }

    public static void addOptions(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("code").desc(rb.getString("title")).longOpt("title").build());
        opts.addOption(Option.builder().hasArg().argName("code").desc(rb.getString("modifier")).longOpt("modifier").build());
        opts.addOption(Option.builder().hasArg().argName("file|url").desc(rb.getString("code-config")).longOpt("code-config").build());
        opts.addOption(Option.builder().hasArg().argName("text").desc(rb.getString("desc")).longOpt("desc").build());
        opts.addOption(Option.builder().hasArg().argName("aet").desc(rb.getString("retrieve-aet")).longOpt("retrieve-aet").build());
        opts.addOption(Option.builder().hasArg().argName("url").desc(rb.getString("retrieve-url")).longOpt("retrieve-url").build());
        opts.addOption(Option.builder().hasArg().argName("uid").desc(rb.getString("location-uid")).longOpt("location-uid").build());
        opts.addOption(Option.builder().hasArg().argName("no").desc(rb.getString("series-no")).longOpt("series-no").build());
        opts.addOption(Option.builder().hasArg().argName("no").desc(rb.getString("inst-no")).longOpt("inst-no").build());
        opts.addOption(Option.builder((String)"o").hasArg().argName("file").desc(rb.getString("o-file")).build());
        OptionGroup group = new OptionGroup();
        group.addOption(Option.builder((String)"F").longOpt("no-fmi").desc(rb.getString("no-fmi")).build());
        group.addOption(Option.builder((String)"t").longOpt("transfer-syntax").hasArg().argName("uid").desc(rb.getString("transfer-syntax")).build());
        opts.addOptionGroup(group);
        opts.addOption(Option.builder((String)"s").hasArgs().argName("[seq.]attr=value").desc(rb.getString("set")).build());
        opts.addOption(Option.builder().hasArg().argName("suffix").desc(rb.getString("uid-suffix")).longOpt("uid-suffix").build());
        CLIUtils.addEncodingOptions((Options)opts);
    }

    private static void configure(MkKOS main, CommandLine cl) throws Exception {
        main.setCodes(CLIUtils.loadProperties((String)cl.getOptionValue("code-config", "resource:code.properties"), null));
        main.setDocumentTitle(main.toCodeItem(MkKOS.documentTitleOf(cl)));
        if (cl.hasOption("modifier")) {
            main.setDocumentTitleModifier(main.toCodeItem(cl.getOptionValue("modifier")));
        }
        main.setKeyObjectDescription(cl.getOptionValue("desc"));
        main.setRetrieveAET(cl.getOptionValue("retrieve-aet"));
        main.setRetrieveURL(cl.getOptionValue("retrieve-url"));
        main.setLocationUID(cl.getOptionValue("location-uid"));
        main.setSeriesNumber(cl.getOptionValue("series-no", "999"));
        main.setInstanceNumber(cl.getOptionValue("inst-no", "1"));
        main.setOutputFile(MkKOS.outputFileOf(cl));
        main.setNoFileMetaInformation(cl.hasOption("F"));
        main.setTransferSyntax(cl.getOptionValue("t", "1.2.840.10008.1.2.1"));
        main.setEncodingOptions(CLIUtils.encodingOptionsOf((CommandLine)cl));
        CLIUtils.addAttributes((Attributes)main.attrs, (String[])cl.getOptionValues("s"));
        main.setUIDSuffix(cl.getOptionValue("uid-suffix"));
    }

    public static String outputFileOf(CommandLine cl) throws MissingOptionException {
        if (!cl.hasOption("o")) {
            throw new MissingOptionException(rb.getString("missing-o-file"));
        }
        return cl.getOptionValue("o");
    }

    private static String documentTitleOf(CommandLine cl) throws MissingOptionException {
        if (!cl.hasOption("title")) {
            throw new MissingOptionException(rb.getString("missing-title"));
        }
        return cl.getOptionValue("title");
    }

    public Attributes toCodeItem(String codeValue) {
        if (this.codes == null) {
            throw new IllegalStateException("codes not initialized");
        }
        String codeMeaning = this.codes.getProperty(codeValue);
        if (codeMeaning == null) {
            throw new IllegalArgumentException("undefined code value: " + codeValue);
        }
        int endDesignator = codeValue.indexOf(45);
        Attributes attrs = new Attributes(3);
        attrs.setString(524544, VR.SH, endDesignator >= 0 ? codeValue.substring(endDesignator + 1) : codeValue);
        attrs.setString(524546, VR.SH, endDesignator >= 0 ? codeValue.substring(0, endDesignator) : "DCM");
        attrs.setString(524548, VR.LO, codeMeaning);
        return attrs;
    }

    public boolean addInstance(Attributes inst) {
        CLIUtils.updateAttributes((Attributes)inst, (Attributes)this.attrs, (String)this.uidSuffix);
        String studyIUID = inst.getString(0x20000D);
        String seriesIUID = inst.getString(0x20000E);
        String iuid = inst.getString(524312);
        String cuid = inst.getString(524310);
        if (studyIUID == null || seriesIUID == null || iuid == null || cuid == null) {
            return false;
        }
        if (this.kos == null) {
            this.kos = this.createKOS(inst);
        }
        this.refSOPSeq(this.refSeriesSeq(studyIUID), seriesIUID).add(this.refSOP(cuid, iuid));
        this.contentSeq.add(this.contentItem(this.valueTypeOf(inst), this.refSOP(cuid, iuid)));
        return true;
    }

    public void writeKOS() throws IOException {
        dos.setEncodingOptions(this.encOpts);
        try (DicomOutputStream dos = new DicomOutputStream((OutputStream)new BufferedOutputStream(this.fname != null ? new FileOutputStream(this.fname) : new FileOutputStream(FileDescriptor.out)), this.nofmi ? "1.2.840.10008.1.2" : "1.2.840.10008.1.2.1");){
            dos.writeDataset(this.nofmi ? null : this.kos.createFileMetaInformation(this.tsuid), this.kos);
        }
    }

    private Sequence refSeriesSeq(String studyIUID) {
        for (Attributes refStudy : this.evidenceSeq) {
            if (!studyIUID.equals(refStudy.getString(0x20000D))) continue;
            return refStudy.getSequence(528661);
        }
        Attributes refStudy = new Attributes(2);
        Sequence refSeriesSeq = refStudy.newSequence(528661, 10);
        refStudy.setString(0x20000D, VR.UI, studyIUID);
        this.evidenceSeq.add(refStudy);
        return refSeriesSeq;
    }

    private Sequence refSOPSeq(Sequence refSeriesSeq, String seriesIUID) {
        for (Attributes refSeries : refSeriesSeq) {
            if (!seriesIUID.equals(refSeries.getString(0x20000E))) continue;
            return refSeries.getSequence(528793);
        }
        Attributes refSeries = new Attributes(5);
        if (this.retrieveAET != null) {
            refSeries.setString(524372, VR.AE, this.retrieveAET);
        }
        if (this.retrieveURL != null) {
            refSeries.setString(528784, VR.UR, this.retrieveURL);
        }
        Sequence refSOPSeq = refSeries.newSequence(528793, 100);
        refSeries.setString(0x20000E, VR.UI, seriesIUID);
        if (this.locationUID != null) {
            refSeries.setString(4251665, VR.UI, this.locationUID);
        }
        refSeriesSeq.add(refSeries);
        return refSOPSeq;
    }

    private String valueTypeOf(Attributes inst) {
        return inst.contains(2621444) ? "IMAGE" : (inst.contains(1409286400) ? "WAVEFORM" : "COMPOSITE");
    }

    private Attributes refSOP(String cuid, String iuid) {
        Attributes item = new Attributes(2);
        item.setString(528720, VR.UI, cuid);
        item.setString(528725, VR.UI, iuid);
        return item;
    }

    private Attributes createKOS(Attributes inst) {
        Attributes attrs = new Attributes(inst, PATIENT_AND_STUDY_ATTRS);
        attrs.setString(524310, VR.UI, "1.2.840.10008.5.1.4.1.1.88.59");
        attrs.setString(524312, VR.UI, UIDUtils.createUID());
        attrs.setDate(2251950138064947L, new Date[]{new Date()});
        attrs.setString(524384, VR.CS, "KO");
        attrs.setNull(528657, VR.SQ);
        attrs.setString(0x20000E, VR.UI, UIDUtils.createUID());
        attrs.setString(0x200011, VR.IS, this.seriesNumber);
        attrs.setString(2097171, VR.IS, this.instanceNumber);
        attrs.setString(0x40A040, VR.CS, "CONTAINER");
        attrs.setString(4235344, VR.CS, "SEPARATE");
        attrs.newSequence(4235331, 1).add(this.documentTitle);
        this.evidenceSeq = attrs.newSequence(4236149, 1);
        attrs.newSequence(4236548, 1).add(this.templateIdentifier());
        this.contentSeq = attrs.newSequence(4237104, 1);
        if (this.documentTitleModifier != null) {
            this.contentSeq.add(this.documentTitleModifier());
        }
        if (this.keyObjectDescription != null) {
            this.contentSeq.add(this.keyObjectDescription());
        }
        return attrs;
    }

    private Attributes templateIdentifier() {
        Attributes attrs = new Attributes(2);
        attrs.setString(524549, VR.CS, "DCMR");
        attrs.setString(4250368, VR.CS, "2010");
        return attrs;
    }

    private Attributes documentTitleModifier() {
        Attributes item = new Attributes(4);
        item.setString(4235280, VR.CS, "HAS CONCEPT MOD");
        item.setString(0x40A040, VR.CS, "CODE");
        item.newSequence(4235331, 1).add(this.toCodeItem("DCM-113011"));
        item.newSequence(4235624, 1).add(this.documentTitleModifier);
        return item;
    }

    private Attributes keyObjectDescription() {
        Attributes item = new Attributes(4);
        item.setString(4235280, VR.CS, "CONTAINS");
        item.setString(0x40A040, VR.CS, "TEXT");
        item.newSequence(4235331, 1).add(this.toCodeItem("DCM-113012"));
        item.setString(4235616, VR.UT, this.keyObjectDescription);
        return item;
    }

    private Attributes contentItem(String valueType, Attributes refSOP) {
        Attributes item = new Attributes(3);
        item.setString(4235280, VR.CS, "CONTAINS");
        item.setString(0x40A040, VR.CS, valueType);
        item.newSequence(528793, 1).add(refSOP);
        return item;
    }
}

