/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.mppsscp;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IOD;
import org.dcm4che3.data.ValidationResult;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DimseRQHandler;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.service.BasicCEchoSCP;
import org.dcm4che3.net.service.BasicMPPSSCP;
import org.dcm4che3.net.service.DicomService;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.DicomServiceRegistry;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.SafeClose;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MppsSCP {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.mppsscp.messages");
    private static final Logger LOG = LoggerFactory.getLogger(MppsSCP.class);
    private final Device device = new Device("mppsscp");
    private final ApplicationEntity ae = new ApplicationEntity("*");
    private final Connection conn = new Connection();
    private File storageDir;
    private IOD mppsNCreateIOD;
    private IOD mppsNSetIOD;
    private final BasicMPPSSCP mppsSCP = new BasicMPPSSCP(){

        protected Attributes create(Association as, Attributes rq, Attributes rqAttrs, Attributes rsp) throws DicomServiceException {
            return MppsSCP.this.create(as, rq, rqAttrs);
        }

        protected Attributes set(Association as, Attributes rq, Attributes rqAttrs, Attributes rsp) throws DicomServiceException {
            return MppsSCP.this.set(as, rq, rqAttrs);
        }
    };

    public MppsSCP() throws IOException {
        this.device.addConnection(this.conn);
        this.device.addApplicationEntity(this.ae);
        this.ae.setAssociationAcceptor(true);
        this.ae.addConnection(this.conn);
        DicomServiceRegistry serviceRegistry = new DicomServiceRegistry();
        serviceRegistry.addDicomService((DicomService)new BasicCEchoSCP());
        serviceRegistry.addDicomService((DicomService)this.mppsSCP);
        this.ae.setDimseRQHandler((DimseRQHandler)serviceRegistry);
    }

    public void setStorageDirectory(File storageDir) {
        if (storageDir != null) {
            storageDir.mkdirs();
        }
        this.storageDir = storageDir;
    }

    public File getStorageDirectory() {
        return this.storageDir;
    }

    private void setMppsNCreateIOD(IOD mppsNCreateIOD) {
        this.mppsNCreateIOD = mppsNCreateIOD;
    }

    private void setMppsNSetIOD(IOD mppsNSetIOD) {
        this.mppsNSetIOD = mppsNSetIOD;
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = MppsSCP.parseComandLine(args);
            MppsSCP main = new MppsSCP();
            CLIUtils.configureBindServer((Connection)main.conn, (ApplicationEntity)main.ae, (CommandLine)cl);
            CLIUtils.configure((Connection)main.conn, (CommandLine)cl);
            CLIUtils.configureAcceptedCallingAETitles((ApplicationEntity)main.ae, (CommandLine)cl, (Logger)LOG);
            MppsSCP.configureTransferCapability(main.ae, cl);
            MppsSCP.configureStorageDirectory(main, cl);
            MppsSCP.configureIODs(main, cl);
            ExecutorService executorService = Executors.newCachedThreadPool();
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            main.device.setScheduledExecutor(scheduledExecutorService);
            main.device.setExecutor((Executor)executorService);
            main.device.bindConnections();
        }
        catch (ParseException e) {
            System.err.println("mppsscp: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("mppsscp: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addBindServerOption((Options)opts);
        CLIUtils.addAEOptions((Options)opts);
        CLIUtils.addAcceptedCallingAETs((Options)opts);
        CLIUtils.addCommonOptions((Options)opts);
        MppsSCP.addStorageDirectoryOptions(opts);
        MppsSCP.addTransferCapabilityOptions(opts);
        MppsSCP.addIODOptions(opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, MppsSCP.class);
    }

    private static void addStorageDirectoryOptions(Options opts) {
        opts.addOption(null, "ignore", false, rb.getString("ignore"));
        opts.addOption(Option.builder().hasArg().argName("path").desc(rb.getString("directory")).longOpt("directory").build());
    }

    private static void addTransferCapabilityOptions(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("file|url").desc(rb.getString("sop-classes")).longOpt("sop-classes").build());
    }

    private static void addIODOptions(Options opts) {
        opts.addOption(null, "no-validate", false, rb.getString("no-validate"));
        opts.addOption(Option.builder().hasArg().argName("file|url").desc(rb.getString("ncreate-iod")).longOpt("ncreate-iod").build());
        opts.addOption(Option.builder().hasArg().argName("file|url").desc(rb.getString("nset-iod")).longOpt("nset-iod").build());
    }

    private static void configureStorageDirectory(MppsSCP main, CommandLine cl) {
        if (!cl.hasOption("ignore")) {
            main.setStorageDirectory(new File(cl.getOptionValue("directory", ".")));
        }
    }

    private static void configureIODs(MppsSCP main, CommandLine cl) throws IOException {
        if (!cl.hasOption("no-validate")) {
            main.setMppsNCreateIOD(IOD.load((String)cl.getOptionValue("mpps-ncreate-iod", "resource:mpps-ncreate-iod.xml")));
            main.setMppsNSetIOD(IOD.load((String)cl.getOptionValue("mpps-nset-iod", "resource:mpps-nset-iod.xml")));
        }
    }

    private static void configureTransferCapability(ApplicationEntity ae, CommandLine cl) throws IOException {
        Properties p = CLIUtils.loadProperties((String)cl.getOptionValue("sop-classes", "resource:sop-classes.properties"), null);
        for (String cuid : p.stringPropertyNames()) {
            String ts = p.getProperty(cuid);
            ae.addTransferCapability(new TransferCapability(null, CLIUtils.toUID((String)cuid), TransferCapability.Role.SCP, CLIUtils.toUIDs((String)ts)));
        }
    }

    private Attributes create(Association as, Attributes rq, Attributes rqAttrs) throws DicomServiceException {
        ValidationResult result;
        if (this.mppsNCreateIOD != null && !(result = rqAttrs.validate(this.mppsNCreateIOD)).isValid()) {
            throw DicomServiceException.valueOf((ValidationResult)result, (Attributes)rqAttrs);
        }
        if (this.storageDir == null) {
            return null;
        }
        String cuid = rq.getString(2);
        String iuid = rq.getString(4096);
        File file = new File(this.storageDir, iuid);
        if (file.exists()) {
            throw new DicomServiceException(273).setUID(4096, iuid);
        }
        DicomOutputStream out = null;
        LOG.info("{}: M-WRITE {}", (Object)as, (Object)file);
        try {
            out = new DicomOutputStream(file);
            out.writeDataset(Attributes.createFileMetaInformation((String)iuid, (String)cuid, (String)"1.2.840.10008.1.2.1"), rqAttrs);
        }
        catch (IOException e) {
            try {
                LOG.warn(as + ": Failed to store MPPS:", (Throwable)e);
                throw new DicomServiceException(272, (Throwable)e);
            }
            catch (Throwable throwable) {
                SafeClose.close(out);
                throw throwable;
            }
        }
        SafeClose.close((Closeable)out);
        return null;
    }

    private Attributes set(Association as, Attributes rq, Attributes rqAttrs) throws DicomServiceException {
        Attributes data;
        ValidationResult result;
        if (this.mppsNSetIOD != null && !(result = rqAttrs.validate(this.mppsNSetIOD)).isValid()) {
            throw DicomServiceException.valueOf((ValidationResult)result, (Attributes)rqAttrs);
        }
        if (this.storageDir == null) {
            return null;
        }
        String cuid = rq.getString(3);
        String iuid = rq.getString(4097);
        File file = new File(this.storageDir, iuid);
        if (!file.exists()) {
            throw new DicomServiceException(274).setUID(4096, iuid);
        }
        LOG.info("{}: M-UPDATE {}", (Object)as, (Object)file);
        DicomInputStream in = null;
        try {
            in = new DicomInputStream(file);
            data = in.readDataset();
        }
        catch (IOException e) {
            try {
                LOG.warn(as + ": Failed to read MPPS:", (Throwable)e);
                throw new DicomServiceException(272, (Throwable)e);
            }
            catch (Throwable throwable) {
                SafeClose.close(in);
                throw throwable;
            }
        }
        SafeClose.close((Closeable)in);
        if (!"IN PROGRESS".equals(data.getString(4194898))) {
            BasicMPPSSCP.mayNoLongerBeUpdated();
        }
        data.addAll(rqAttrs);
        DicomOutputStream out = null;
        try {
            out = new DicomOutputStream(file);
            out.writeDataset(Attributes.createFileMetaInformation((String)iuid, (String)cuid, (String)"1.2.840.10008.1.2.1"), data);
        }
        catch (IOException e) {
            try {
                LOG.warn(as + ": Failed to update MPPS:", (Throwable)e);
                throw new DicomServiceException(272, (Throwable)e);
            }
            catch (Throwable throwable) {
                SafeClose.close(out);
                throw throwable;
            }
        }
        SafeClose.close((Closeable)out);
        return null;
    }
}

