/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.storescp;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.DimseRQHandler;
import org.dcm4che3.net.PDVInputStream;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.BasicCEchoSCP;
import org.dcm4che3.net.service.BasicCStoreSCP;
import org.dcm4che3.net.service.DicomService;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.DicomServiceRegistry;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.AttributesFormat;
import org.dcm4che3.util.SafeClose;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSCP {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSCP.class);
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.storescp.messages");
    private static final String PART_EXT = ".part";
    private final Device device = new Device("storescp");
    private final ApplicationEntity ae = new ApplicationEntity("*");
    private final Connection conn = new Connection();
    private File storageDir;
    private AttributesFormat filePathFormat;
    private int status;
    private int[] receiveDelays;
    private int[] responseDelays;
    private int renameRetries;
    private int renameRetryJitter;
    private final BasicCStoreSCP cstoreSCP = new BasicCStoreSCP(new String[]{"*"}){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void store(Association as, PresentationContext pc, Attributes rq, PDVInputStream data, Attributes rsp) throws IOException {
            StoreSCP.this.sleep(as, StoreSCP.this.receiveDelays);
            try {
                rsp.setInt(2304, VR.US, new int[]{StoreSCP.this.status});
                if (StoreSCP.this.storageDir == null) {
                    return;
                }
                String cuid = rq.getString(2);
                String iuid = rq.getString(4096);
                String tsuid = pc.getTransferSyntax();
                File file = File.createTempFile(iuid, StoreSCP.PART_EXT, StoreSCP.this.storageDir);
                try {
                    StoreSCP.this.storeTo(as, as.createFileMetaInformation(iuid, cuid, tsuid), data, file);
                    StoreSCP.this.renameTo(as, file, new File(StoreSCP.this.storageDir, StoreSCP.this.filePathFormat == null ? iuid : StoreSCP.this.filePathFormat.format((Object)StoreSCP.parse(file))));
                }
                catch (Exception e) {
                    StoreSCP.deleteFile(as, file);
                    throw new DicomServiceException(272, (Throwable)e);
                }
            }
            finally {
                StoreSCP.this.sleep(as, StoreSCP.this.responseDelays);
            }
        }
    };

    private void sleep(Association as, int[] delays) {
        int responseDelay;
        int n = responseDelay = delays != null ? delays[(as.getNumberOfReceived(Dimse.C_STORE_RQ) - 1) % delays.length] : 0;
        if (responseDelay > 0) {
            try {
                Thread.sleep(responseDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public StoreSCP() throws IOException {
        this.device.setDimseRQHandler((DimseRQHandler)this.createServiceRegistry());
        this.device.addConnection(this.conn);
        this.device.addApplicationEntity(this.ae);
        this.ae.setAssociationAcceptor(true);
        this.ae.addConnection(this.conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTo(Association as, Attributes fmi, PDVInputStream data, File file) throws IOException {
        LOG.info("{}: M-WRITE {}", (Object)as, (Object)file);
        file.getParentFile().mkdirs();
        DicomOutputStream out = new DicomOutputStream(file);
        try {
            out.writeFileMetaInformation(fmi);
            data.copyTo((OutputStream)out);
        }
        finally {
            SafeClose.close((Closeable)out);
        }
    }

    private void renameTo(Association as, File from, File dest) throws IOException {
        LOG.info("{}: M-RENAME {} to {}", new Object[]{as, from, dest});
        for (int try_count = 0; try_count <= this.renameRetries; ++try_count) {
            try {
                dest.getParentFile().mkdirs();
                Files.move(from.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
                return;
            }
            catch (IOException e) {
                if (try_count == this.renameRetries) {
                    throw e;
                }
                try {
                    Thread.sleep((long)(Math.random() * (double)this.renameRetryJitter));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    private static Attributes parse(File file) throws IOException {
        DicomInputStream in = new DicomInputStream(file);
        try {
            in.setIncludeBulkData(DicomInputStream.IncludeBulkData.NO);
            Attributes attributes = in.readDatasetUntilPixelData();
            return attributes;
        }
        finally {
            SafeClose.close((Closeable)in);
        }
    }

    private static void deleteFile(Association as, File file) {
        if (file.delete()) {
            LOG.info("{}: M-DELETE {}", (Object)as, (Object)file);
        } else {
            LOG.warn("{}: M-DELETE {} failed!", (Object)as, (Object)file);
        }
    }

    private DicomServiceRegistry createServiceRegistry() {
        DicomServiceRegistry serviceRegistry = new DicomServiceRegistry();
        serviceRegistry.addDicomService((DicomService)new BasicCEchoSCP());
        serviceRegistry.addDicomService((DicomService)this.cstoreSCP);
        return serviceRegistry;
    }

    public void setStorageDirectory(File storageDir) {
        if (storageDir != null) {
            storageDir.mkdirs();
        }
        this.storageDir = storageDir;
    }

    public void setStorageFilePathFormat(String pattern) {
        this.filePathFormat = new AttributesFormat(pattern);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setReceiveDelays(int[] receiveDelays) {
        this.receiveDelays = receiveDelays;
    }

    public void setResponseDelays(int[] responseDelays) {
        this.responseDelays = responseDelays;
    }

    public void setRenameRetries(int renameRetries) {
        if (renameRetries < 0) {
            throw new IllegalArgumentException("Rename retries must be a non-negative value!");
        }
        this.renameRetries = renameRetries;
    }

    public void setRenameRetryJitter(int renameRetryJitter) {
        if (renameRetryJitter < 0) {
            throw new IllegalArgumentException("Rename retry jitter must be a non-negative value!");
        }
        this.renameRetryJitter = renameRetryJitter;
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addBindServerOption((Options)opts);
        CLIUtils.addAEOptions((Options)opts);
        CLIUtils.addAcceptedCallingAETs((Options)opts);
        CLIUtils.addCommonOptions((Options)opts);
        StoreSCP.addStatusOption(opts);
        StoreSCP.addDelayOption(opts, "receive-delay");
        StoreSCP.addDelayOption(opts, "response-delay");
        StoreSCP.addStorageDirectoryOptions(opts);
        StoreSCP.addTransferCapabilityOptions(opts);
        StoreSCP.addRenameRetryOptions(opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, StoreSCP.class);
    }

    private static void addStatusOption(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("code").desc(rb.getString("status")).longOpt("status").build());
    }

    private static void addDelayOption(Options opts, String longOpt) {
        opts.addOption(Option.builder().hasArgs().argName("ms").desc(rb.getString(longOpt)).longOpt(longOpt).build());
    }

    private static void addStorageDirectoryOptions(Options opts) {
        opts.addOption(null, "ignore", false, rb.getString("ignore"));
        opts.addOption(Option.builder().hasArg().argName("path").desc(rb.getString("directory")).longOpt("directory").build());
        opts.addOption(Option.builder().hasArg().argName("pattern").desc(rb.getString("filepath")).longOpt("filepath").build());
    }

    private static void addTransferCapabilityOptions(Options opts) {
        opts.addOption(null, "accept-unknown", false, rb.getString("accept-unknown"));
        opts.addOption(Option.builder().hasArg().argName("file|url").desc(rb.getString("sop-classes")).longOpt("sop-classes").build());
    }

    private static void addRenameRetryOptions(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("count").desc(rb.getString("rename-retries")).longOpt("rename-retries").build());
        opts.addOption(Option.builder().hasArg().argName("ms").desc(rb.getString("rename-retry-jitter")).longOpt("rename-retry-jitter").build());
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = StoreSCP.parseComandLine(args);
            StoreSCP main = new StoreSCP();
            CLIUtils.configureBindServer((Connection)main.conn, (ApplicationEntity)main.ae, (CommandLine)cl);
            CLIUtils.configure((Connection)main.conn, (CommandLine)cl);
            CLIUtils.configureAcceptedCallingAETitles((ApplicationEntity)main.ae, (CommandLine)cl, (Logger)LOG);
            main.setStatus(CLIUtils.getIntOption((CommandLine)cl, (String)"status", (int)0));
            main.setReceiveDelays(CLIUtils.getIntsOption((CommandLine)cl, (String)"receive-delay"));
            main.setResponseDelays(CLIUtils.getIntsOption((CommandLine)cl, (String)"response-delay"));
            StoreSCP.configureTransferCapability(main.ae, cl);
            StoreSCP.configureStorageDirectory(main, cl);
            main.setRenameRetries(CLIUtils.getIntOption((CommandLine)cl, (String)"rename-retries", (int)3));
            main.setRenameRetryJitter(CLIUtils.getIntOption((CommandLine)cl, (String)"rename-retry-jitter", (int)50));
            ExecutorService executorService = Executors.newCachedThreadPool();
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            main.device.setScheduledExecutor(scheduledExecutorService);
            main.device.setExecutor((Executor)executorService);
            main.device.bindConnections();
        }
        catch (ParseException e) {
            System.err.println("storescp: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("storescp: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static void configureStorageDirectory(StoreSCP main, CommandLine cl) {
        if (!cl.hasOption("ignore")) {
            main.setStorageDirectory(new File(cl.getOptionValue("directory", ".")));
            if (cl.hasOption("filepath")) {
                main.setStorageFilePathFormat(cl.getOptionValue("filepath"));
            }
        }
    }

    private static void configureTransferCapability(ApplicationEntity ae, CommandLine cl) throws IOException {
        if (cl.hasOption("accept-unknown")) {
            ae.addTransferCapability(new TransferCapability(null, "*", TransferCapability.Role.SCP, new String[]{"*"}));
        } else {
            Properties p = CLIUtils.loadProperties((String)cl.getOptionValue("sop-classes", "resource:sop-classes.properties"), null);
            for (String cuid : p.stringPropertyNames()) {
                String ts = p.getProperty(cuid);
                TransferCapability tc = new TransferCapability(null, CLIUtils.toUID((String)cuid), TransferCapability.Role.SCP, CLIUtils.toUIDs((String)ts));
                ae.addTransferCapability(tc);
            }
        }
    }
}

