/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.storescu;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.imageio.codec.Decompressor;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.SAXReader;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.DataWriter;
import org.dcm4che3.net.DataWriterAdapter;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DimseRSPHandler;
import org.dcm4che3.net.IncompatibleConnectionException;
import org.dcm4che3.net.InputStreamDataWriter;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.tool.common.DicomFiles;
import org.dcm4che3.tool.storescu.RelatedGeneralSOPClasses;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;
import org.xml.sax.SAXException;

public class StoreSCU {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.storescu.messages");
    private final ApplicationEntity ae;
    private final Connection remote;
    private final AAssociateRQ rq = new AAssociateRQ();
    private final RelatedGeneralSOPClasses relSOPClasses = new RelatedGeneralSOPClasses();
    private Attributes attrs;
    private String uidSuffix;
    private boolean relExtNeg;
    private int priority;
    private String tmpPrefix = "storescu-";
    private String tmpSuffix;
    private File tmpDir;
    private File tmpFile;
    private Association as;
    private long totalSize;
    private int filesScanned;
    private int filesSent;
    private RSPHandlerFactory rspHandlerFactory = new RSPHandlerFactory(){

        @Override
        public DimseRSPHandler createDimseRSPHandler(final File f) {
            return new DimseRSPHandler(StoreSCU.this.as.nextMessageID()){

                public void onDimseRSP(Association as, Attributes cmd, Attributes data) {
                    super.onDimseRSP(as, cmd, data);
                    StoreSCU.this.onCStoreRSP(cmd, f);
                }
            };
        }
    };

    public StoreSCU(ApplicationEntity ae) throws IOException {
        this.remote = new Connection();
        this.ae = ae;
        this.rq.addPresentationContext(new PresentationContext(1, "1.2.840.10008.1.1", new String[]{"1.2.840.10008.1.2"}));
    }

    public void setRspHandlerFactory(RSPHandlerFactory rspHandlerFactory) {
        this.rspHandlerFactory = rspHandlerFactory;
    }

    public AAssociateRQ getAAssociateRQ() {
        return this.rq;
    }

    public Connection getRemoteConnection() {
        return this.remote;
    }

    public Attributes getAttributes() {
        return this.attrs;
    }

    public void setAttributes(Attributes attrs) {
        this.attrs = attrs;
    }

    public void setTmpFile(File tmpFile) {
        this.tmpFile = tmpFile;
    }

    public final void setPriority(int priority) {
        this.priority = priority;
    }

    public final void setUIDSuffix(String uidSuffix) {
        this.uidSuffix = uidSuffix;
    }

    public final void setTmpFilePrefix(String prefix) {
        this.tmpPrefix = prefix;
    }

    public final void setTmpFileSuffix(String suffix) {
        this.tmpSuffix = suffix;
    }

    public final void setTmpFileDirectory(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addConnectOption((Options)opts);
        CLIUtils.addBindClientOption((Options)opts, (String)"STORESCU");
        CLIUtils.addAEOptions((Options)opts);
        CLIUtils.addStoreTimeoutOption((Options)opts);
        CLIUtils.addResponseTimeoutOption((Options)opts);
        CLIUtils.addPriorityOption((Options)opts);
        CLIUtils.addCommonOptions((Options)opts);
        StoreSCU.addStoreTCOptions(opts);
        StoreSCU.addTmpFileOptions(opts);
        StoreSCU.addRelatedSOPClassOptions(opts);
        StoreSCU.addAttributesOption(opts);
        StoreSCU.addUIDSuffixOption(opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, StoreSCU.class);
    }

    private static void addAttributesOption(Options opts) {
        opts.addOption(Option.builder((String)"s").hasArgs().argName("[seq.]attr=value").desc(rb.getString("set")).build());
    }

    public static void addUIDSuffixOption(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("suffix").desc(rb.getString("uid-suffix")).longOpt("uid-suffix").build());
    }

    private static void addStoreTCOptions(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("cuid:tsuid[(,|;)...]").desc(rb.getString("store-tc")).longOpt("store-tc").build());
        opts.addOption(Option.builder().hasArg().argName("file|url").desc(rb.getString("store-tcs")).longOpt("store-tcs").build());
    }

    public static void addTmpFileOptions(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("directory").desc(rb.getString("tmp-file-dir")).longOpt("tmp-file-dir").build());
        opts.addOption(Option.builder().hasArg().argName("prefix").desc(rb.getString("tmp-file-prefix")).longOpt("tmp-file-prefix").build());
        opts.addOption(Option.builder().hasArg().argName("suffix").desc(rb.getString("tmp-file-suffix")).longOpt("tmp-file-suffix").build());
    }

    private static void addRelatedSOPClassOptions(Options opts) {
        opts.addOption(null, "rel-ext-neg", false, rb.getString("rel-ext-neg"));
        opts.addOption(Option.builder().hasArg().argName("file|url").desc(rb.getString("rel-sop-classes")).longOpt("rel-sop-classes").build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            long t2;
            long t1;
            CommandLine cl = StoreSCU.parseComandLine(args);
            Device device = new Device("storescu");
            Connection conn = new Connection();
            device.addConnection(conn);
            ApplicationEntity ae = new ApplicationEntity("STORESCU");
            device.addApplicationEntity(ae);
            ae.addConnection(conn);
            StoreSCU main = new StoreSCU(ae);
            StoreSCU.configureTmpFile(main, cl);
            CLIUtils.configureConnect((Connection)main.remote, (AAssociateRQ)main.rq, (CommandLine)cl);
            CLIUtils.configureBind((Connection)conn, (ApplicationEntity)ae, (CommandLine)cl);
            CLIUtils.configure((Connection)conn, (CommandLine)cl);
            main.remote.setTlsProtocols(conn.getTlsProtocols());
            main.remote.setTlsCipherSuites(conn.getTlsCipherSuites());
            StoreSCU.configureRelatedSOPClass(main, cl);
            main.setAttributes(new Attributes());
            CLIUtils.addAttributes((Attributes)main.attrs, (String[])cl.getOptionValues("s"));
            main.setUIDSuffix(cl.getOptionValue("uid-suffix"));
            main.setPriority(CLIUtils.priorityOf((CommandLine)cl));
            List argList = cl.getArgList();
            boolean echo = argList.isEmpty();
            if (echo) {
                StoreSCU.configureStorageSOPClasses(main, cl);
            } else {
                System.out.println(rb.getString("scanning"));
                t1 = System.currentTimeMillis();
                main.scanFiles(argList);
                t2 = System.currentTimeMillis();
                int n = main.filesScanned;
                System.out.println();
                if (n == 0) {
                    return;
                }
                System.out.println(MessageFormat.format(rb.getString("scanned"), n, Float.valueOf((float)(t2 - t1) / 1000.0f), (t2 - t1) / (long)n));
            }
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            device.setExecutor((Executor)executorService);
            device.setScheduledExecutor(scheduledExecutorService);
            try {
                t1 = System.currentTimeMillis();
                main.open();
                t2 = System.currentTimeMillis();
                System.out.println(MessageFormat.format(rb.getString("connected"), main.as.getRemoteAET(), t2 - t1));
                if (echo) {
                    main.echo();
                } else {
                    t1 = System.currentTimeMillis();
                    main.sendFiles();
                    t2 = System.currentTimeMillis();
                }
            }
            finally {
                main.close();
                executorService.shutdown();
                scheduledExecutorService.shutdown();
            }
            if (main.filesScanned > 0) {
                float s = (float)(t2 - t1) / 1000.0f;
                float mb = (float)main.totalSize / 1048576.0f;
                System.out.println(MessageFormat.format(rb.getString("sent"), main.filesSent, Float.valueOf(mb), Float.valueOf(s), Float.valueOf(mb / s)));
            }
        }
        catch (ParseException e) {
            System.err.println("storescu: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("storescu: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    public static String uidSuffixOf(CommandLine cl) {
        return cl.getOptionValue("uid-suffix");
    }

    private static void configureTmpFile(StoreSCU storescu, CommandLine cl) {
        if (cl.hasOption("tmp-file-dir")) {
            storescu.setTmpFileDirectory(new File(cl.getOptionValue("tmp-file-dir")));
        }
        storescu.setTmpFilePrefix(cl.getOptionValue("tmp-file-prefix", "storescu-"));
        storescu.setTmpFileSuffix(cl.getOptionValue("tmp-file-suffix"));
    }

    public static void configureRelatedSOPClass(StoreSCU storescu, CommandLine cl) throws IOException {
        if (cl.hasOption("rel-ext-neg")) {
            storescu.enableSOPClassRelationshipExtNeg(true);
            Properties p = new Properties();
            CLIUtils.loadProperties((String)(cl.hasOption("rel-sop-classes") ? cl.getOptionValue("rel-ext-neg") : "resource:rel-sop-classes.properties"), (Properties)p);
            storescu.relSOPClasses.init(p);
        }
    }

    private static void configureStorageSOPClasses(StoreSCU main, CommandLine cl) throws Exception {
        String[] files;
        String[] pcs = cl.getOptionValues("store-tc");
        if (pcs != null) {
            for (String pc : pcs) {
                String[] ss = StringUtils.split((String)pc, (char)':');
                StoreSCU.configureStorageSOPClass(main, ss[0], ss[1]);
            }
        }
        if ((files = cl.getOptionValues("store-tcs")) != null) {
            for (String file : files) {
                Properties p = CLIUtils.loadProperties((String)file, null);
                Set<Map.Entry<Object, Object>> entrySet = p.entrySet();
                for (Map.Entry<Object, Object> entry : entrySet) {
                    StoreSCU.configureStorageSOPClass(main, (String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
    }

    private static void configureStorageSOPClass(StoreSCU main, String cuid, String tsuids0) {
        for (String tsuids2 : StringUtils.split((String)tsuids0, (char)';')) {
            main.addOfferedStorageSOPClass(CLIUtils.toUID((String)cuid), CLIUtils.toUIDs((String)tsuids2));
        }
    }

    public void addOfferedStorageSOPClass(String cuid, String ... tsuids) {
        this.rq.addPresentationContext(new PresentationContext(2 * this.rq.getNumberOfPresentationContexts() + 1, cuid, tsuids));
    }

    public final void enableSOPClassRelationshipExtNeg(boolean enable) {
        this.relExtNeg = enable;
    }

    public void scanFiles(List<String> fnames) throws IOException {
        this.scanFiles(fnames, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanFiles(List<String> fnames, boolean printout) throws IOException {
        this.tmpFile = File.createTempFile(this.tmpPrefix, this.tmpSuffix, this.tmpDir);
        this.tmpFile.deleteOnExit();
        try (final BufferedWriter fileInfos = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.tmpFile)));){
            DicomFiles.scan(fnames, (boolean)printout, (DicomFiles.Callback)new DicomFiles.Callback(){

                public boolean dicomFile(File f, Attributes fmi, long dsPos, Attributes ds) throws IOException {
                    if (!StoreSCU.this.addFile(fileInfos, f, dsPos, fmi, ds)) {
                        return false;
                    }
                    StoreSCU.this.filesScanned++;
                    return true;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendFiles() throws IOException {
        BufferedReader fileInfos = new BufferedReader(new InputStreamReader(new FileInputStream(this.tmpFile)));
        try {
            String line;
            while (this.as.isReadyForDataTransfer() && (line = fileInfos.readLine()) != null) {
                String[] ss = StringUtils.split((String)line, (char)'\t');
                try {
                    this.send(new File(ss[4]), Long.parseLong(ss[3]), ss[1], ss[0], ss[2]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                this.as.waitForOutstandingRSP();
                return;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
        finally {
            SafeClose.close((Closeable)fileInfos);
        }
    }

    public boolean addFile(BufferedWriter fileInfos, File f, long endFmi, Attributes fmi, Attributes ds) throws IOException {
        String cuid = fmi.getString(131074);
        String iuid = fmi.getString(131075);
        String ts = fmi.getString(131088);
        if (cuid == null || iuid == null) {
            return false;
        }
        fileInfos.write(iuid);
        fileInfos.write(9);
        fileInfos.write(cuid);
        fileInfos.write(9);
        fileInfos.write(ts);
        fileInfos.write(9);
        fileInfos.write(Long.toString(endFmi));
        fileInfos.write(9);
        fileInfos.write(f.getPath());
        fileInfos.newLine();
        if (this.rq.containsPresentationContextFor(cuid, ts)) {
            return true;
        }
        if (!this.rq.containsPresentationContextFor(cuid)) {
            if (this.relExtNeg) {
                this.rq.addCommonExtendedNegotiation(this.relSOPClasses.getCommonExtendedNegotiation(cuid));
            }
            if (!ts.equals("1.2.840.10008.1.2.1")) {
                this.rq.addPresentationContext(new PresentationContext(this.rq.getNumberOfPresentationContexts() * 2 + 1, cuid, new String[]{"1.2.840.10008.1.2.1"}));
            }
            if (!ts.equals("1.2.840.10008.1.2")) {
                this.rq.addPresentationContext(new PresentationContext(this.rq.getNumberOfPresentationContexts() * 2 + 1, cuid, new String[]{"1.2.840.10008.1.2"}));
            }
        }
        this.rq.addPresentationContext(new PresentationContext(this.rq.getNumberOfPresentationContexts() * 2 + 1, cuid, new String[]{ts}));
        return true;
    }

    public void echo() throws IOException, InterruptedException {
        this.as.cecho().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(File f, long fmiEndPos, String cuid, String iuid, String filets) throws IOException, InterruptedException, ParserConfigurationException, SAXException {
        String ts = this.selectTransferSyntax(cuid, filets);
        if (f.getName().endsWith(".xml")) {
            Attributes parsedDicomFile = SAXReader.parse((InputStream)new FileInputStream(f));
            if (CLIUtils.updateAttributes((Attributes)parsedDicomFile, (Attributes)this.attrs, (String)this.uidSuffix)) {
                iuid = parsedDicomFile.getString(524312);
            }
            if (!ts.equals(filets)) {
                Decompressor.decompress((Attributes)parsedDicomFile, (String)filets);
            }
            this.as.cstore(cuid, iuid, this.priority, (DataWriter)new DataWriterAdapter(parsedDicomFile), ts, this.rspHandlerFactory.createDimseRSPHandler(f));
        } else {
            if (this.uidSuffix == null && this.attrs.isEmpty() && ts.equals(filets)) {
                FileInputStream in = new FileInputStream(f);
                try {
                    in.skip(fmiEndPos);
                    InputStreamDataWriter data = new InputStreamDataWriter((InputStream)in);
                    this.as.cstore(cuid, iuid, this.priority, (DataWriter)data, ts, this.rspHandlerFactory.createDimseRSPHandler(f));
                }
                finally {
                    SafeClose.close((Closeable)in);
                }
            }
            DicomInputStream in = new DicomInputStream(f);
            try {
                in.setIncludeBulkData(DicomInputStream.IncludeBulkData.URI);
                Attributes data = in.readDataset();
                if (CLIUtils.updateAttributes((Attributes)data, (Attributes)this.attrs, (String)this.uidSuffix)) {
                    iuid = data.getString(524312);
                }
                if (!ts.equals(filets)) {
                    Decompressor.decompress((Attributes)data, (String)filets);
                }
                this.as.cstore(cuid, iuid, this.priority, (DataWriter)new DataWriterAdapter(data), ts, this.rspHandlerFactory.createDimseRSPHandler(f));
            }
            finally {
                SafeClose.close((Closeable)in);
            }
        }
    }

    private String selectTransferSyntax(String cuid, String filets) {
        Set tss = this.as.getTransferSyntaxesFor(cuid);
        if (tss.contains(filets)) {
            return filets;
        }
        if (tss.contains("1.2.840.10008.1.2.1")) {
            return "1.2.840.10008.1.2.1";
        }
        return "1.2.840.10008.1.2";
    }

    public void close() throws IOException, InterruptedException {
        if (this.as != null) {
            if (this.as.isReadyForDataTransfer()) {
                this.as.release();
            }
            this.as.waitForSocketClose();
        }
    }

    public void open() throws IOException, InterruptedException, IncompatibleConnectionException, GeneralSecurityException {
        this.as = this.ae.connect(this.remote, this.rq);
    }

    private void onCStoreRSP(Attributes cmd, File f) {
        int status = cmd.getInt(2304, -1);
        switch (status) {
            case 0: {
                this.totalSize += f.length();
                ++this.filesSent;
                System.out.print('.');
                break;
            }
            case 45056: 
            case 45062: 
            case 45063: {
                this.totalSize += f.length();
                ++this.filesSent;
                System.err.println(MessageFormat.format(rb.getString("warning"), TagUtils.shortToHexString((int)status), f));
                System.err.println(cmd);
                break;
            }
            default: {
                System.out.print('E');
                System.err.println(MessageFormat.format(rb.getString("error"), TagUtils.shortToHexString((int)status), f));
                System.err.println(cmd);
            }
        }
    }

    public static interface RSPHandlerFactory {
        public DimseRSPHandler createDimseRSPHandler(File var1);
    }
}

