/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.stowrsd;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Executors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.mime.MultipartInputStream;
import org.dcm4che3.mime.MultipartParser;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.DateUtils;
import org.dcm4che3.util.StreamUtils;
import org.dcm4che3.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StowRSServer {
    private static final Logger LOG = LoggerFactory.getLogger(StowRSServer.class);
    private static final ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.stowrsd.messages");
    private final byte[] responseXML = StowRSServer.loadResource("resource:response.xml");
    private final byte[] responseJSON = StowRSServer.loadResource("resource:response.json");
    private final HttpServer server;
    private Path storageDir;
    private boolean unpack;
    private static final OutputStream NULL = new OutputStream(){

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }
    };

    public StowRSServer(InetSocketAddress addr, int backlog, int threads) throws IOException {
        this.server = HttpServer.create(addr, backlog);
        if (threads > 1) {
            this.server.setExecutor(Executors.newFixedThreadPool(threads));
        }
        this.server.createContext("/", this::handle);
    }

    public void start() {
        LOG.info("Start listening on {}", (Object)this.server.getAddress());
        this.server.start();
    }

    public void stop(int delay) {
        this.server.stop(delay);
    }

    private void handle(HttpExchange httpExchange) throws IOException {
        LOG.info("{} -> {}{}< {} {} {}{}", new Object[]{httpExchange.getRemoteAddress(), httpExchange.getLocalAddress(), System.lineSeparator(), httpExchange.getRequestMethod(), httpExchange.getRequestURI(), httpExchange.getProtocol(), new LogHeaders("< ", httpExchange.getRequestHeaders().entrySet())});
        switch (httpExchange.getRequestMethod()) {
            case "POST": {
                this.onPOST(httpExchange);
                break;
            }
            case "OPTIONS": {
                this.onOPTIONS(httpExchange);
                break;
            }
            default: {
                StowRSServer.sendResponseHeaders(httpExchange, 405, "Method Not Allowed", -1);
            }
        }
    }

    private void onOPTIONS(HttpExchange httpExchange) throws IOException {
        Headers requestHeaders = httpExchange.getRequestHeaders();
        Headers responseHeaders = httpExchange.getResponseHeaders();
        StowRSServer.setNotNull(responseHeaders, "Access-control-allow-origin", requestHeaders.getFirst("Origin"));
        StowRSServer.setNotNull(responseHeaders, "Access-control-allow-methods", requestHeaders.getFirst("Access-control-request-method"));
        StowRSServer.setNotNull(responseHeaders, "Access-control-allow-headers", requestHeaders.getFirst("Access-control-request-headers"));
        StowRSServer.sendResponseHeaders(httpExchange, 204, "No Content", -1);
    }

    private void onPOST(HttpExchange httpExchange) throws IOException {
        block17: {
            String requestContentType = httpExchange.getRequestHeaders().getFirst("Content-type");
            if (requestContentType == null) {
                LOG.warn("Missing Content-type header");
                StowRSServer.sendResponseHeaders(httpExchange, 400, "Bad Request", -1);
                return;
            }
            String[] requestContentTypeParams = StringUtils.split((String)requestContentType, (char)';');
            if (!"multipart/related".equalsIgnoreCase(requestContentTypeParams[0])) {
                StowRSServer.sendResponseHeaders(httpExchange, 415, "Unsupported Media Type", -1);
                return;
            }
            if (this.unpack) {
                String boundary = StowRSServer.boundary(requestContentTypeParams);
                if (boundary == null) {
                    LOG.warn("Missing boundary parameter in Content-type: {}", (Object)requestContentType);
                    StowRSServer.sendResponseHeaders(httpExchange, 400, "Bad Request", -1);
                    return;
                }
                new MultipartParser(boundary).parse(httpExchange.getRequestBody(), (MultipartParser.Handler)new MultipartHandler());
            } else {
                if (this.storageDir != null) {
                    Date now = new Date();
                    while (true) {
                        try {
                            Path file = this.storageDir.resolve(DateUtils.formatDT(null, (Date)now) + ".multipart");
                            Files.copy(httpExchange.getRequestBody(), file, new CopyOption[0]);
                            LOG.info("* M-WRITE {}", (Object)file);
                            break block17;
                        }
                        catch (FileAlreadyExistsException e) {
                            now = new Date(now.getTime() + 1L);
                            continue;
                        }
                        break;
                    }
                }
                StreamUtils.skipAll((InputStream)httpExchange.getRequestBody());
            }
        }
        String mediaType = StowRSServer.selectMediaType(httpExchange);
        if (mediaType != null) {
            byte[] response = mediaType.endsWith("xml") ? this.responseXML : this.responseJSON;
            Headers requestHeaders = httpExchange.getRequestHeaders();
            Headers responseHeaders = httpExchange.getResponseHeaders();
            StowRSServer.setNotNull(responseHeaders, "Access-control-allow-origin", requestHeaders.getFirst("Origin"));
            responseHeaders.set("Content-type", mediaType);
            StowRSServer.sendResponseHeaders(httpExchange, 200, "OK", response.length);
            try (OutputStream out = httpExchange.getResponseBody();){
                out.write(response);
            }
        } else {
            StowRSServer.sendResponseHeaders(httpExchange, 406, "Not Acceptable", -1);
        }
    }

    private static void setNotNull(Headers responseHeaders, String key, String value) {
        if (value != null) {
            responseHeaders.set(key, value);
        }
    }

    private static String boundary(String[] params) {
        for (int i = 1; i < params.length; ++i) {
            String param = params[i].trim();
            if (param.length() <= 12 || !param.startsWith("boundary=")) continue;
            return param.charAt(9) == '\"' && param.charAt(param.length() - 1) == '\"' ? param.substring(10, param.length() - 1) : param.substring(9);
        }
        return null;
    }

    private static void sendResponseHeaders(HttpExchange httpExchange, int rCode, String rMsg, int responseLength) throws IOException {
        httpExchange.sendResponseHeaders(rCode, responseLength);
        LOG.info("{} -> {}{}> {} {} {}{}", new Object[]{httpExchange.getRemoteAddress(), httpExchange.getLocalAddress(), System.lineSeparator(), httpExchange.getProtocol(), rCode, rMsg, new LogHeaders("> ", httpExchange.getResponseHeaders().entrySet())});
    }

    private static byte[] loadResource(String name) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamUtils.copy((InputStream)StreamUtils.openFileOrURL((String)name), (OutputStream)out);
        return out.toByteArray();
    }

    private static String selectMediaType(HttpExchange httpExchange) {
        Iterator iterator = httpExchange.getRequestHeaders().get("Accept").iterator();
        while (iterator.hasNext()) {
            String acceptHeader = (String)iterator.next();
            for (String mediaType : StringUtils.split((String)acceptHeader, (char)',')) {
                switch (StowRSServer.withoutParams(mediaType).toLowerCase()) {
                    case "*": 
                    case "*/*": 
                    case "application/*": 
                    case "application/dicom+json": {
                        return "application/dicom+json";
                    }
                    case "application/json": {
                        return "application/json";
                    }
                    case "application/dicom+xml": {
                        return "application/dicom+xml";
                    }
                    case "text/*": 
                    case "text/xml": {
                        return "text/xml";
                    }
                }
            }
        }
        return null;
    }

    private static String withoutParams(String mediaType) {
        int endIndex = mediaType.indexOf(59);
        return endIndex < 0 ? mediaType : mediaType.substring(0, endIndex);
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = StowRSServer.parseComandLine(args);
            StowRSServer main = new StowRSServer(StowRSServer.toInetSocketAddress(cl), CLIUtils.getIntOption((CommandLine)cl, (String)"backlog", (int)0), CLIUtils.getIntOption((CommandLine)cl, (String)"threads", (int)1));
            if (!cl.hasOption("ignore")) {
                main.setStorageDirectory(Paths.get(cl.getOptionValue("d", "."), new String[0]));
            }
            main.setUnpack(cl.hasOption("u"));
            main.start();
        }
        catch (ParseException e) {
            System.err.println("stowrsd: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("stowrsd: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    public void setStorageDirectory(Path storageDir) throws IOException {
        if (storageDir != null) {
            Files.createDirectories(storageDir, new FileAttribute[0]);
        }
        this.storageDir = storageDir;
    }

    public void setUnpack(boolean unpack) {
        this.unpack = unpack;
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        StowRSServer.addOptions(opts);
        CLIUtils.addCommonOptions((Options)opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, StowRSServer.class);
    }

    public static void addOptions(Options opts) {
        opts.addOption("u", "unpack", false, rb.getString("unpack"));
        opts.addOption(null, "ignore", false, rb.getString("ignore"));
        opts.addOption(Option.builder((String)"d").hasArg().argName("path").desc(rb.getString("directory")).longOpt("directory").build());
        opts.addOption(Option.builder().hasArg().argName("no").desc(rb.getString("backlog")).longOpt("backlog").build());
        opts.addOption(Option.builder((String)"t").hasArg().argName("no").desc(rb.getString("threads")).longOpt("threads").build());
        opts.addOption(Option.builder((String)"b").hasArg().argName("[ip:]port").desc(rb.getString("bind-server")).longOpt("bind").build());
    }

    private static InetSocketAddress toInetSocketAddress(CommandLine cl) throws MissingOptionException {
        if (!cl.hasOption("b")) {
            throw new MissingOptionException(rb.getString("missing-bind-opt"));
        }
        String s = cl.getOptionValue("b");
        int index = s.indexOf(58);
        return index < 0 ? new InetSocketAddress(Integer.parseInt(s)) : new InetSocketAddress(s.substring(0, index), Integer.parseInt(s.substring(index + 1)));
    }

    private static String suffix(List<String> contentTypes) {
        if (contentTypes.isEmpty()) {
            return "";
        }
        String[] split = StringUtils.split((String)contentTypes.get(0).toLowerCase(), (char)';');
        return split[0].endsWith("dicom") ? ".dcm" : (split[0].endsWith("xml") ? ".xml" : (split[0].endsWith("json") ? ".json" : ""));
    }

    private static class LogHeaders {
        final String prefix;
        final Set<Map.Entry<String, List<String>>> headers;

        LogHeaders(String prefix, Set<Map.Entry<String, List<String>>> headers) {
            this.prefix = prefix;
            this.headers = headers;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, List<String>> entry : this.headers) {
                sb.append(System.lineSeparator()).append(this.prefix).append(entry.getKey()).append(": ").append(entry.getValue());
            }
            return sb.toString();
        }
    }

    private class MultipartHandler
    implements MultipartParser.Handler {
        private Path storageSupDir;

        MultipartHandler() throws IOException {
            if (StowRSServer.this.storageDir != null) {
                Date now = new Date();
                while (true) {
                    try {
                        this.storageSupDir = Files.createDirectory(StowRSServer.this.storageDir.resolve(DateUtils.formatDT(null, (Date)now)), new FileAttribute[0]);
                    }
                    catch (FileAlreadyExistsException e) {
                        now = new Date(now.getTime() + 1L);
                        continue;
                    }
                    break;
                }
            }
        }

        public void bodyPart(int partNumber, MultipartInputStream in) throws IOException {
            Map partHeaders = in.readHeaderParams();
            LOG.info("< Part #{}:{}", (Object)partNumber, (Object)new LogHeaders("< ", partHeaders.entrySet()));
            if (this.storageSupDir != null) {
                Path file = this.storageSupDir.resolve(String.format("%03d", partNumber) + StowRSServer.suffix((List)partHeaders.get("Content-type")));
                LOG.info("* M-WRITE {}", (Object)file);
                Files.copy((InputStream)in, file, new CopyOption[0]);
            } else {
                in.skipAll();
            }
        }
    }
}

