/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.syslog;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DeviceExtension;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4che3.net.audit.AuditLoggerDeviceExtension;
import org.dcm4che3.net.audit.AuditRecordRepository;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StreamUtils;
import org.dcm4che3.util.StringUtils;

public class Syslog {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.syslog.messages");
    private final Connection conn = new Connection();
    private final Connection remote = new Connection();
    private final AuditLoggerDeviceExtension auditLoggerExt = new AuditLoggerDeviceExtension();
    private final AuditLogger auditLogger = new AuditLogger();
    private final AuditRecordRepository arr = new AuditRecordRepository();
    private final Device logDevice = new Device("syslog");
    private final Device arrDevice = new Device("syslogd");
    private int delayBetweenMessages;

    public Syslog() throws IOException {
        this.logDevice.addDeviceExtension((DeviceExtension)this.auditLoggerExt);
        this.logDevice.addConnection(this.conn);
        this.arrDevice.addDeviceExtension((DeviceExtension)this.arr);
        this.arrDevice.addConnection(this.remote);
        this.auditLogger.setAuditRecordRepositoryDevice(this.arrDevice);
        this.auditLoggerExt.addAuditLogger(this.auditLogger);
    }

    private void setProtocol(Connection.Protocol protocol) {
        this.conn.setProtocol(protocol);
        this.remote.setProtocol(protocol);
        this.auditLogger.addConnection(this.conn);
        this.arr.addConnection(this.remote);
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        Syslog.addConnectOption(opts);
        Syslog.addBindOption(opts);
        Syslog.addAuditLogger(opts);
        Syslog.addSendOptions(opts);
        CLIUtils.addSocketOptions((Options)opts);
        CLIUtils.addTLSOptions((Options)opts);
        CLIUtils.addCommonOptions((Options)opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, Syslog.class);
    }

    private static void addConnectOption(Options opts) {
        opts.addOption(Option.builder((String)"c").hasArg().argName("host:port").desc(rb.getString("connect")).longOpt("connect").build());
        opts.addOption(Option.builder().hasArg().argName("[user:password@]host:port").desc(rb.getString("proxy")).longOpt("proxy").build());
        opts.addOption(null, "udp", false, rb.getString("udp"));
        CLIUtils.addConnectTimeoutOption((Options)opts);
        opts.addOption(Option.builder().hasArg().argName("ms").desc(rb.getString("idle-timeout")).longOpt("idle-timeout").build());
    }

    private static void addBindOption(Options opts) {
        opts.addOption(Option.builder((String)"b").hasArg().argName("ip").desc(rb.getString("bind")).longOpt("bind").build());
    }

    private static void addAuditLogger(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("facility").desc(rb.getString("facility")).longOpt("facility").build());
        opts.addOption(Option.builder().hasArg().argName("level").desc(rb.getString("level")).longOpt("level").build());
        opts.addOption(Option.builder().hasArg().argName("name").desc(rb.getString("app-name")).longOpt("app-name").build());
        opts.addOption(Option.builder().hasArg().argName("id").desc(rb.getString("msg-id")).longOpt("msg-id").build());
        opts.addOption(null, "utc", false, rb.getString("utc"));
        opts.addOption(null, "no-bom", false, rb.getString("no-bom"));
        opts.addOption(Option.builder().hasArg().argName("s").desc(rb.getString("retry")).longOpt("retry").build());
        opts.addOption(Option.builder().hasArg().argName("dir").desc(rb.getString("spool-dir")).longOpt("spool-dir").build());
    }

    private static void addSendOptions(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("ms").desc(rb.getString("delay")).longOpt("delay").build());
    }

    private static void configureConnect(Connection conn, CommandLine cl) throws MissingOptionException, ParseException {
        if (!cl.hasOption("c")) {
            throw new MissingOptionException(CLIUtils.rb.getString("missing-connect-opt"));
        }
        String[] hostPort = StringUtils.split((String)cl.getOptionValue("c"), (char)':');
        if (hostPort.length != 2) {
            throw new ParseException(CLIUtils.rb.getString("invalid-connect-opt"));
        }
        conn.setHostname(hostPort[0]);
        conn.setPort(Integer.parseInt(hostPort[1]));
        conn.setHttpProxy(cl.getOptionValue("proxy"));
    }

    private static void configureBind(Connection conn, CommandLine cl) {
        if (cl.hasOption("b")) {
            conn.setHostname(cl.getOptionValue("b"));
        }
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = Syslog.parseComandLine(args);
            Syslog main = new Syslog();
            Syslog.configureConnect(main.remote, cl);
            main.setProtocol(Syslog.toProtocol(cl));
            Syslog.configureAuditLogger(main.auditLogger, cl);
            main.setDelayBetweenMessages(CLIUtils.getIntOption((CommandLine)cl, (String)"delay", (int)0));
            Syslog.configureBind(main.conn, cl);
            CLIUtils.configure((Connection)main.conn, (CommandLine)cl);
            try {
                main.init();
                main.sendFiles(cl.getArgList());
                main.waitForNoQueuedMessages();
            }
            finally {
                main.close();
            }
        }
        catch (ParseException e) {
            System.err.println("syslog: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("syslog: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private void waitForNoQueuedMessages() throws InterruptedException {
        this.auditLogger.waitForNoQueuedMessages(0L);
    }

    private void setDelayBetweenMessages(int delayBetweenMessages) {
        this.delayBetweenMessages = delayBetweenMessages;
    }

    private static void configureAuditLogger(AuditLogger logger, CommandLine cl) {
        logger.setFacility(Syslog.toFacility(cl));
        logger.setSuccessSeverity(Syslog.toSeverity(cl));
        logger.setApplicationName(cl.getOptionValue("app-name"));
        logger.setMessageID(cl.getOptionValue("msg-id", "IHE+RFC-3881"));
        logger.setIncludeBOM(!cl.hasOption("no-bom"));
        logger.setTimestampInUTC(cl.hasOption("utc"));
        if (cl.hasOption("spool-dir")) {
            logger.setSpoolDirectory(new File(cl.getOptionValue("spool-dir")));
        }
        logger.setRetryInterval(CLIUtils.getIntOption((CommandLine)cl, (String)"retry", (int)0));
    }

    private static AuditLogger.Severity toSeverity(CommandLine cl) {
        return AuditLogger.Severity.valueOf((String)cl.getOptionValue("level", "info"));
    }

    private static AuditLogger.Facility toFacility(CommandLine cl) {
        return AuditLogger.Facility.valueOf((String)cl.getOptionValue("facility", "authpriv"));
    }

    private static Connection.Protocol toProtocol(CommandLine cl) {
        return cl.hasOption("udp") ? Connection.Protocol.SYSLOG_UDP : Connection.Protocol.SYSLOG_TLS;
    }

    public void init() {
        this.remote.setTlsProtocols(this.conn.getTlsProtocols());
        this.remote.setTlsCipherSuites(this.conn.getTlsCipherSuites());
        this.logDevice.setScheduledExecutor(Executors.newSingleThreadScheduledExecutor());
        this.auditLogger.sendQueuedMessages();
    }

    public void close() {
        this.auditLogger.closeActiveConnection();
        ScheduledExecutorService scheduler = this.logDevice.getScheduledExecutor();
        if (scheduler != null) {
            scheduler.shutdown();
        }
    }

    public void sendFiles(List<String> pathnames) throws Exception {
        int count = 0;
        for (String pathname : pathnames) {
            if (count++ > 0 && this.delayBetweenMessages > 0) {
                Thread.sleep(this.delayBetweenMessages);
            }
            byte[] b = this.readFile(pathname);
            this.auditLogger.write(this.auditLogger.timeStamp(), this.auditLogger.getSuccessSeverity(), b, 0, b.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(String pathname) throws IOException {
        FileInputStream in;
        block3: {
            byte[] byArray;
            in = null;
            try {
                if (!pathname.equals("-")) break block3;
                in = new FileInputStream(FileDescriptor.in);
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                StreamUtils.copy((InputStream)in, (OutputStream)buf);
                byArray = buf.toByteArray();
            }
            catch (Throwable throwable) {
                SafeClose.close(in);
                throw throwable;
            }
            SafeClose.close((Closeable)in);
            return byArray;
        }
        File f = new File(pathname);
        in = new FileInputStream(f);
        byte[] b = new byte[(int)f.length()];
        StreamUtils.readFully((InputStream)in, (byte[])b, (int)0, (int)b.length);
        byte[] byArray = b;
        SafeClose.close((Closeable)in);
        return byArray;
    }
}

