/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.ws.rs;

import jakarta.ws.rs.core.MediaType;
import java.util.Collections;
import java.util.HashMap;

public class MediaTypes {
    public static final String APPLICATION_DICOM = "application/dicom";
    public static final MediaType APPLICATION_DICOM_TYPE = new MediaType("application", "dicom");
    public static final String APPLICATION_DICOM_XML = "application/dicom+xml";
    public static final MediaType APPLICATION_DICOM_XML_TYPE = new MediaType("application", "dicom+xml");
    public static final String APPLICATION_DICOM_JSON = "application/dicom+json";
    public static final MediaType APPLICATION_DICOM_JSON_TYPE = new MediaType("application", "dicom+json");
    public static final String IMAGE_WILDCARD = "image/*";
    public static final MediaType IMAGE_WILDCARD_TYPE = new MediaType("image", "*");
    public static final String IMAGE_GIF = "image/gif";
    public static final MediaType IMAGE_GIF_TYPE = new MediaType("image", "gif");
    public static final String IMAGE_PNG = "image/png";
    public static final MediaType IMAGE_PNG_TYPE = new MediaType("image", "png");
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final MediaType IMAGE_JPEG_TYPE = new MediaType("image", "jpeg");
    public static final String IMAGE_JLS = "image/jls";
    public static final MediaType IMAGE_JLS_TYPE = new MediaType("image", "jls");
    public static final String IMAGE_JP2 = "image/jp2";
    public static final MediaType IMAGE_JP2_TYPE = new MediaType("image", "jp2");
    public static final String IMAGE_J2C = "image/j2c";
    public static final MediaType IMAGE_J2C_TYPE = new MediaType("image", "j2c");
    public static final String IMAGE_JPX = "image/jpx";
    public static final MediaType IMAGE_JPX_TYPE = new MediaType("image", "jpx");
    public static final String IMAGE_JPH = "image/jph";
    public static final MediaType IMAGE_JPH_TYPE = new MediaType("image", "jph");
    public static final String IMAGE_JPHC = "image/jphc";
    public static final MediaType IMAGE_JPHC_TYPE = new MediaType("image", "jphc");
    public static final String IMAGE_DICOM_RLE = "image/dicom-rle";
    public static final MediaType IMAGE_DICOM_RLE_TYPE = new MediaType("image", "dicom-rle");
    public static final String VIDEO_WILDCARD = "video/*";
    public static final MediaType VIDEO_WILDCARD_TYPE = new MediaType("video", "*");
    public static final String VIDEO_MPEG = "video/mpeg";
    public static final MediaType VIDEO_MPEG_TYPE = new MediaType("video", "mpeg");
    public static final String VIDEO_MP4 = "video/mp4";
    public static final MediaType VIDEO_MP4_TYPE = new MediaType("video", "mp4");
    public static final String VIDEO_QUICKTIME = "video/quicktime";
    public static final MediaType VIDEO_QUICKTIME_TYPE = new MediaType("video", "quicktime");
    public static final String APPLICATION_PDF = "application/pdf";
    public static final MediaType APPLICATION_PDF_TYPE = new MediaType("application", "pdf");
    public static final String TEXT_RTF = "text/rtf";
    public static final MediaType TEXT_RTF_TYPE = new MediaType("text", "rtf");
    public static final String TEXT_CSV = "text/csv";
    public static final MediaType TEXT_CSV_TYPE = new MediaType("text", "csv");
    public static final String TEXT_CSV_UTF8 = "text/csv;charset=utf-8";
    public static final MediaType TEXT_CSV_UTF8_TYPE = new MediaType("text", "csv", "utf-8");
    public static final String APPLICATION_ZIP = "application/zip";
    public static final MediaType APPLICATION_ZIP_TYPE = new MediaType("application", "zip");
    public static final String MULTIPART_RELATED = "multipart/related";
    public static final MediaType MULTIPART_RELATED_TYPE = new MediaType("multipart", "related");
    public static final String MULTIPART_RELATED_APPLICATION_DICOM = "multipart/related;type=\"application/dicom\"";
    public static final MediaType MULTIPART_RELATED_APPLICATION_DICOM_TYPE = new MediaType("multipart", "related", Collections.singletonMap("type", "application/dicom"));
    public static final String MULTIPART_RELATED_APPLICATION_DICOM_XML = "multipart/related;type=\"application/dicom+xml\"";
    public static final MediaType MULTIPART_RELATED_APPLICATION_DICOM_XML_TYPE = new MediaType("multipart", "related", Collections.singletonMap("type", "application/dicom+xml"));
    public static final String MODEL_STL = "model/stl";
    public static final MediaType MODEL_STL_TYPE = new MediaType("model", "stl");
    public static final String MODEL_X_STL_BINARY = "model/x.stl-binary";
    public static final MediaType MODEL_X_STL_BINARY_TYPE = new MediaType("model", "x.stl-binary");
    public static final String APPLICATION_SLA = "application/sla";
    public static final MediaType APPLICATION_SLA_TYPE = new MediaType("application", "sla");
    public static final String MODEL_OBJ = "model/obj";
    public static final MediaType MODEL_OBJ_TYPE = new MediaType("model", "obj");
    public static final String MODEL_MTL = "model/mtl";
    public static final MediaType MODEL_MTL_TYPE = new MediaType("model", "mtl");
    public static final String APPLICATION_VND_GENOZIP = "application/vnd.genozip";
    public static final MediaType APPLICATION_VND_GENOZIP_TYPE = new MediaType("application", "vnd.genozip");
    public static final String APPLICATION_X_BZIP2 = "application/x-bzip2";
    public static final MediaType APPLICATION_X_BZIP2_TYPE = new MediaType("application", "x-bzip2");
    public static final String APPLICATION_PRS_VCFBZIP2 = "application/prs.vcfbzip2";
    public static final MediaType APPLICATION_PRS_VCFBZIP2_TYPE = new MediaType("application", "prs.vcfbzip2");

    public static MediaType forTransferSyntax(String ts) {
        MediaType type;
        switch (ts) {
            case "1.2.840.10008.1.2.1": 
            case "1.2.840.10008.1.2": {
                return MediaType.APPLICATION_OCTET_STREAM_TYPE;
            }
            case "1.2.840.10008.1.2.5": {
                return IMAGE_DICOM_RLE_TYPE;
            }
            case "1.2.840.10008.1.2.4.50": 
            case "1.2.840.10008.1.2.4.51": 
            case "1.2.840.10008.1.2.4.57": 
            case "1.2.840.10008.1.2.4.70": {
                type = IMAGE_JPEG_TYPE;
                break;
            }
            case "1.2.840.10008.1.2.4.80": 
            case "1.2.840.10008.1.2.4.81": {
                type = IMAGE_JLS_TYPE;
                break;
            }
            case "1.2.840.10008.1.2.4.90": 
            case "1.2.840.10008.1.2.4.91": {
                type = IMAGE_JP2_TYPE;
                break;
            }
            case "1.2.840.10008.1.2.4.92": 
            case "1.2.840.10008.1.2.4.93": {
                type = IMAGE_JPX_TYPE;
                break;
            }
            case "1.2.840.10008.1.2.4.201": 
            case "1.2.840.10008.1.2.4.202": 
            case "1.2.840.10008.1.2.4.203": {
                type = IMAGE_JPHC_TYPE;
                break;
            }
            case "1.2.840.10008.1.2.4.100": 
            case "1.2.840.10008.1.2.4.101": {
                type = VIDEO_MPEG_TYPE;
                break;
            }
            case "1.2.840.10008.1.2.4.102": 
            case "1.2.840.10008.1.2.4.103": {
                type = VIDEO_MP4_TYPE;
                break;
            }
            default: {
                throw new IllegalArgumentException("ts: " + ts);
            }
        }
        return new MediaType(type.getType(), type.getSubtype(), Collections.singletonMap("transfer-syntax", ts));
    }

    public static String transferSyntaxOf(MediaType bulkdataMediaType) {
        String tsuid = (String)bulkdataMediaType.getParameters().get("transfer-syntax");
        if (tsuid != null) {
            return tsuid;
        }
        String type = bulkdataMediaType.getType().toLowerCase();
        String subtype = bulkdataMediaType.getSubtype().toLowerCase();
        switch (type) {
            case "image": {
                switch (subtype) {
                    case "jpeg": {
                        return "1.2.840.10008.1.2.4.70";
                    }
                    case "jls": 
                    case "x-jls": {
                        return "1.2.840.10008.1.2.4.80";
                    }
                    case "jp2": {
                        return "1.2.840.10008.1.2.4.90";
                    }
                    case "jpx": {
                        return "1.2.840.10008.1.2.4.92";
                    }
                    case "x-dicom-rle": 
                    case "dicom-rle": {
                        return "1.2.840.10008.1.2.5";
                    }
                }
            }
            case "video": {
                switch (subtype) {
                    case "mpeg": {
                        return "1.2.840.10008.1.2.4.100";
                    }
                    case "mp4": 
                    case "quicktime": {
                        return "1.2.840.10008.1.2.4.102";
                    }
                }
            }
        }
        return "1.2.840.10008.1.2.1";
    }

    public static String sopClassOf(MediaType bulkdataMediaType) {
        String type = bulkdataMediaType.getType().toLowerCase();
        return type.equals("image") ? "1.2.840.10008.5.1.4.1.1.7" : (type.equals("video") ? "1.2.840.10008.5.1.4.1.1.77.1.4.1" : (MediaTypes.equalsIgnoreParameters(bulkdataMediaType, APPLICATION_PDF_TYPE) ? "1.2.840.10008.5.1.4.1.1.104.1" : (MediaTypes.equalsIgnoreParameters(bulkdataMediaType, MediaType.APPLICATION_XML_TYPE) ? "1.2.840.10008.5.1.4.1.1.104.2" : (MediaTypes.isSTLType(bulkdataMediaType) ? "1.2.840.10008.5.1.4.1.1.104.3" : (MediaTypes.equalsIgnoreParameters(bulkdataMediaType, MODEL_OBJ_TYPE) ? "1.2.840.10008.5.1.4.1.1.104.4" : (MediaTypes.equalsIgnoreParameters(bulkdataMediaType, MODEL_MTL_TYPE) ? "1.2.840.10008.5.1.4.1.1.104.5" : null))))));
    }

    public static boolean isSTLType(MediaType mediaType) {
        return MediaTypes.equalsIgnoreParameters(mediaType, MODEL_STL_TYPE) || MediaTypes.equalsIgnoreParameters(mediaType, MODEL_X_STL_BINARY_TYPE) || MediaTypes.equalsIgnoreParameters(mediaType, APPLICATION_SLA_TYPE);
    }

    public static boolean isSTLType(String type) {
        return MODEL_STL.equalsIgnoreCase(type) || MODEL_X_STL_BINARY.equalsIgnoreCase(type) || APPLICATION_SLA.equalsIgnoreCase(type);
    }

    public static boolean equalsIgnoreParameters(MediaType type1, MediaType type2) {
        return type1.getType().equalsIgnoreCase(type2.getType()) && type1.getSubtype().equalsIgnoreCase(type2.getSubtype());
    }

    public static MediaType getMultiPartRelatedType(MediaType mediaType) {
        if (!MULTIPART_RELATED_TYPE.isCompatible(mediaType)) {
            return null;
        }
        String type = (String)mediaType.getParameters().get("type");
        if (type == null) {
            return MediaType.WILDCARD_TYPE;
        }
        MediaType partType = MediaType.valueOf((String)type);
        if (mediaType.getParameters().size() > 1) {
            HashMap params = new HashMap(mediaType.getParameters());
            params.remove("type");
            partType = new MediaType(partType.getType(), partType.getSubtype(), params);
        }
        return partType;
    }

    public static String getTransferSyntax(MediaType type) {
        return type != null && MediaTypes.equalsIgnoreParameters(APPLICATION_DICOM_TYPE, type) ? (String)type.getParameters().get("transfer-syntax") : null;
    }

    public static MediaType applicationDicomWithTransferSyntax(String tsuid) {
        return new MediaType("application", "dicom", Collections.singletonMap("transfer-syntax", tsuid));
    }
}

