/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.xdsi;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.dcm4che3.xdsi.SlotType1;
import org.dcm4che3.xdsi.ValueListType;
import org.dcm4che3.xdsi.XDSUtils;

public class SlotBuilder {
    private final SlotType1 result = new SlotType1();

    public SlotBuilder(String name) {
        this.result.setName(name);
    }

    public SlotType1 build() {
        return this.result;
    }

    public SlotBuilder valueList(String value) {
        return this.valueList(Collections.singletonList(value));
    }

    public SlotBuilder valueList(Collection<String> values) {
        ValueListType valueList = new ValueListType();
        for (String value : values) {
            valueList.getValue().add(value);
        }
        this.result.setValueList(valueList);
        return this;
    }

    public SlotBuilder valueDTM(Date date) {
        return this.valueList(XDSUtils.formatDTM(date));
    }

    public SlotBuilder slotType(String value) {
        this.result.setSlotType(value);
        return this;
    }
}

