/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.xdsi;

import jakarta.xml.ws.BindingProvider;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.dcm4che3.data.DatePrecision;
import org.dcm4che3.util.DateUtils;
import org.dcm4che3.xdsi.EnsureMustUnderstandHandler;

public class XDSUtils {
    public static void ensureMustUnderstandHandler(Object port) {
        BindingProvider bindingProvider = (BindingProvider)port;
        bindingProvider.getBinding().setHandlerChain(Collections.singletonList(new EnsureMustUnderstandHandler()));
    }

    public static void setEndpointAddress(Object port, String url) throws GeneralSecurityException, IOException {
        BindingProvider bindingProvider = (BindingProvider)port;
        bindingProvider.getBinding().setHandlerChain(Collections.singletonList(new EnsureMustUnderstandHandler()));
        Map reqCtx = bindingProvider.getRequestContext();
        reqCtx.put("jakarta.xml.ws.service.endpoint.address", url);
    }

    public static void setTlsClientParameters(Object port, TLSClientParameters params) {
        Client client = ClientProxy.getClient((Object)port);
        HTTPConduit conduit = (HTTPConduit)client.getConduit();
        conduit.setTlsClientParameters(params);
    }

    public static String formatDTM(Date date) {
        return DateUtils.formatDT((TimeZone)TimeZone.getTimeZone("UTC"), (Date)date, (DatePrecision)new DatePrecision(13));
    }
}

