/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.xroad;

import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.Holder;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.Device;
import org.dcm4che3.xroad.ObjectFactory;
import org.dcm4che3.xroad.RR441RequestType;
import org.dcm4che3.xroad.RR441ResponseType;
import org.dcm4che3.xroad.RequestHash;
import org.dcm4che3.xroad.XRoadAdapterPortType;
import org.dcm4che3.xroad.XRoadClientIdentifierType;
import org.dcm4che3.xroad.XRoadException;
import org.dcm4che3.xroad.XRoadObjectType;
import org.dcm4che3.xroad.XRoadServiceIdentifierType;

public class XRoadUtils {
    private static final ObjectFactory factory = new ObjectFactory();

    public static RR441ResponseType rr441(XRoadAdapterPortType port, Map<String, String> props, RR441RequestType rq, Holder<RequestHash> requestHash) throws XRoadException {
        return XRoadUtils.rr441(port, rq, XRoadUtils.createXRoadClientIdentifierType(props), XRoadUtils.createXRoadServiceIdentifierType(props, "RR441"), props.getOrDefault("userId", "EE11111111111"), props.getOrDefault("id", ""), props.getOrDefault("protocolVersion", "4.0"), requestHash);
    }

    public static RR441ResponseType rr441(XRoadAdapterPortType port, RR441RequestType rq, XRoadClientIdentifierType clientIdentifierType, XRoadServiceIdentifierType serviceIdentifierType, String userID, String id, String protocolVersion, Holder<RequestHash> requestHash) {
        Holder request = new Holder((Object)rq);
        Holder response = new Holder();
        port.rr441((Holder<RR441RequestType>)request, (Holder<XRoadClientIdentifierType>)new Holder((Object)clientIdentifierType), (Holder<XRoadServiceIdentifierType>)new Holder((Object)serviceIdentifierType), (Holder<String>)new Holder((Object)userID), (Holder<String>)new Holder((Object)id), (Holder<String>)new Holder((Object)protocolVersion), (Holder<RR441ResponseType>)response, requestHash);
        return (RR441ResponseType)response.value;
    }

    public static RR441RequestType createRR441RequestType(Map<String, String> props, String patientID) {
        String cValjad = props.getOrDefault("rr441.cValjad", "1,2,6,7,9,10");
        return XRoadUtils.createRR441RequestType(cValjad, patientID);
    }

    public static RR441RequestType createRR441RequestType(String cValjad, String patientID) {
        RR441RequestType rq = factory.createRR441RequestType();
        rq.setCValjad(cValjad);
        rq.setCIsikukoodid(patientID);
        return rq;
    }

    public static Attributes toAttributes(String specificCharacterSet, RR441ResponseType rsp) {
        List<RR441ResponseType.TtIsikuid.TtIsikud> ttIsikudList = rsp.getTtIsikuid().getTtIsikud();
        if (ttIsikudList.isEmpty()) {
            return null;
        }
        RR441ResponseType.TtIsikuid.TtIsikud ttIsikud = ttIsikudList.get(0);
        Attributes attrs = new Attributes();
        attrs.setString(524293, VR.CS, specificCharacterSet);
        attrs.setString(0x100010, VR.PN, XRoadUtils.patientName(ttIsikud));
        attrs.setString(0x100020, VR.LO, ttIsikud.getTtIsikudCIsikukood());
        attrs.setString(0x100040, VR.CS, XRoadUtils.patientSex(ttIsikud.getTtIsikudCSugu()));
        attrs.setString(0x100030, VR.DA, XRoadUtils.patientBirthDate(ttIsikud.getTtIsikudCSynniaeg()));
        attrs.setString("DCM4CHEE Archive 5", 0x777700E0, VR.CS, ttIsikud.getTtIsikudCIsStaatus());
        attrs.setString("DCM4CHEE Archive 5", 2004287713, VR.CS, ttIsikud.getTtIsikudCKirjeStaatus());
        return attrs;
    }

    private static String patientName(RR441ResponseType.TtIsikuid.TtIsikud ttIsikud) {
        return ttIsikud.getTtIsikudCPerenimi() + '^' + ttIsikud.getTtIsikudCEesnimi();
    }

    private static String patientBirthDate(String synniaeg) {
        if (synniaeg == null || synniaeg.length() != 10) {
            return null;
        }
        char[] data = new char[8];
        synniaeg.getChars(6, 10, data, 0);
        synniaeg.getChars(3, 5, data, 4);
        synniaeg.getChars(0, 2, data, 6);
        return new String(data);
    }

    private static String patientSex(String sugu) {
        if (sugu != null && sugu.length() == 1) {
            switch (sugu.charAt(0)) {
                case 'M': {
                    return "M";
                }
                case 'N': {
                    return "F";
                }
            }
        }
        return null;
    }

    public static void setEndpointAddress(Object port, String endpoint) {
        BindingProvider bindingProvider = (BindingProvider)port;
        Map reqCtx = bindingProvider.getRequestContext();
        reqCtx.put("jakarta.xml.ws.service.endpoint.address", endpoint);
    }

    public static void setTlsClientParameters(XRoadAdapterPortType port, Device device, String tlsProtocol, String[] cipherSuites, boolean disableCNCheck) throws GeneralSecurityException, IOException {
        Client client = ClientProxy.getClient((Object)port);
        HTTPConduit conduit = (HTTPConduit)client.getConduit();
        conduit.setTlsClientParameters(XRoadUtils.createTLSClientParameters(device, tlsProtocol, cipherSuites, disableCNCheck));
    }

    private static TLSClientParameters createTLSClientParameters(Device device, String tlsProtocol, String[] cipherSuites, boolean disableCNCheck) throws GeneralSecurityException, IOException {
        TLSClientParameters params = new TLSClientParameters();
        params.setKeyManagers(device.keyManagers());
        params.setTrustManagers(device.trustManagers());
        params.setSecureSocketProtocol(tlsProtocol);
        for (String cipherSuite : cipherSuites) {
            params.getCipherSuites().add(cipherSuite.trim());
        }
        params.setDisableCNCheck(disableCNCheck);
        return params;
    }

    private static XRoadClientIdentifierType createXRoadClientIdentifierType(Map<String, String> props) {
        XRoadClientIdentifierType type = XRoadUtils.createXRoadClientIdentifierType(props.getOrDefault("client.objectType", XRoadObjectType.SUBSYSTEM.name()), props.getOrDefault("client.xRoadInstance", "EE"), props.getOrDefault("client.memberClass", "NGO"), props.getOrDefault("client.memberCode", "90007945"), props.getOrDefault("client.subsystemCode", "mia"));
        return type;
    }

    public static XRoadClientIdentifierType createXRoadClientIdentifierType(String objectTypeName, String xRoadInstance, String memberClass, String memberCode, String subsystemCode) {
        XRoadClientIdentifierType type = factory.createXRoadClientIdentifierType();
        type.setObjectType(XRoadObjectType.valueOf(objectTypeName));
        type.setXRoadInstance(xRoadInstance);
        type.setMemberClass(memberClass);
        type.setMemberCode(memberCode);
        type.setSubsystemCode(subsystemCode);
        return type;
    }

    private static XRoadServiceIdentifierType createXRoadServiceIdentifierType(Map<String, String> props, String serviceCode) {
        return XRoadUtils.createXRoadServiceIdentifierType(serviceCode, props.getOrDefault("service.objectType", XRoadObjectType.SERVICE.name()), props.getOrDefault("service.xRoadInstance", "EE"), props.getOrDefault("service.memberClass", "GOV"), props.getOrDefault("service.memberCode", "70008440"), props.getOrDefault("service.subsystemCode", "rr"), props.getOrDefault("serviceVersion", "v1"));
    }

    public static XRoadServiceIdentifierType createXRoadServiceIdentifierType(String serviceCode, String objectTypeName, String xRoadInstance, String memberClass, String memberCode, String subsystemCode, String serviceVersion) {
        XRoadServiceIdentifierType type = factory.createXRoadServiceIdentifierType();
        type.setObjectType(XRoadObjectType.valueOf(objectTypeName));
        type.setXRoadInstance(xRoadInstance);
        type.setMemberClass(memberClass);
        type.setMemberCode(memberCode);
        type.setSubsystemCode(subsystemCode);
        type.setServiceCode(serviceCode);
        type.setServiceVersion(serviceVersion);
        return type;
    }
}

