/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.gif;

import com.sun.media.imageioimpl.plugins.gif.GIFStreamMetadata;
import javax.imageio.metadata.IIOInvalidTreeException;
import org.w3c.dom.Node;

class GIFWritableStreamMetadata
extends GIFStreamMetadata {
    static final String NATIVE_FORMAT_NAME = "javax_imageio_gif_stream_1.0";

    public GIFWritableStreamMetadata() {
        super(true, NATIVE_FORMAT_NAME, "com.sun.media.imageioimpl.plugins.gif.GIFStreamMetadataFormat", null, null);
        this.reset();
    }

    public boolean isReadOnly() {
        return false;
    }

    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        if (formatName.equals(NATIVE_FORMAT_NAME)) {
            if (root == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeNativeTree(root);
        } else if (formatName.equals("javax_imageio_1.0")) {
            if (root == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeStandardTree(root);
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
    }

    public void reset() {
        this.version = null;
        this.logicalScreenWidth = -1;
        this.logicalScreenHeight = -1;
        this.colorResolution = -1;
        this.pixelAspectRatio = 0;
        this.backgroundColorIndex = 0;
        this.sortFlag = false;
        this.globalColorTable = null;
    }

    protected void mergeNativeTree(Node root) throws IIOInvalidTreeException {
        Node node = root;
        if (!node.getNodeName().equals(NATIVE_FORMAT_NAME)) {
            GIFWritableStreamMetadata.fatal(node, "Root must be javax_imageio_gif_stream_1.0");
        }
        node = node.getFirstChild();
        while (node != null) {
            String name = node.getNodeName();
            if (name.equals("Version")) {
                this.version = GIFWritableStreamMetadata.getStringAttribute(node, "value", null, true, versionStrings);
            } else if (name.equals("LogicalScreenDescriptor")) {
                this.logicalScreenWidth = GIFWritableStreamMetadata.getIntAttribute(node, "logicalScreenWidth", -1, true, true, 1, 65535);
                this.logicalScreenHeight = GIFWritableStreamMetadata.getIntAttribute(node, "logicalScreenHeight", -1, true, true, 1, 65535);
                this.colorResolution = GIFWritableStreamMetadata.getIntAttribute(node, "colorResolution", -1, true, true, 1, 8);
                this.pixelAspectRatio = GIFWritableStreamMetadata.getIntAttribute(node, "pixelAspectRatio", 0, true, true, 0, 255);
            } else if (name.equals("GlobalColorTable")) {
                int sizeOfGlobalColorTable = GIFWritableStreamMetadata.getIntAttribute(node, "sizeOfGlobalColorTable", true, 2, 256);
                if (sizeOfGlobalColorTable != 2 && sizeOfGlobalColorTable != 4 && sizeOfGlobalColorTable != 8 && sizeOfGlobalColorTable != 16 && sizeOfGlobalColorTable != 32 && sizeOfGlobalColorTable != 64 && sizeOfGlobalColorTable != 128 && sizeOfGlobalColorTable != 256) {
                    GIFWritableStreamMetadata.fatal(node, "Bad value for GlobalColorTable attribute sizeOfGlobalColorTable!");
                }
                this.backgroundColorIndex = GIFWritableStreamMetadata.getIntAttribute(node, "backgroundColorIndex", 0, true, true, 0, 255);
                this.sortFlag = GIFWritableStreamMetadata.getBooleanAttribute(node, "sortFlag", false, true);
                this.globalColorTable = this.getColorTable(node, "ColorTableEntry", true, sizeOfGlobalColorTable);
            } else {
                GIFWritableStreamMetadata.fatal(node, "Unknown child of root node!");
            }
            node = node.getNextSibling();
        }
    }

    protected void mergeStandardTree(Node root) throws IIOInvalidTreeException {
        Node node = root;
        if (!node.getNodeName().equals("javax_imageio_1.0")) {
            GIFWritableStreamMetadata.fatal(node, "Root must be javax_imageio_1.0");
        }
        node = node.getFirstChild();
        while (node != null) {
            block27: {
                String childName;
                Node childNode;
                String name = node.getNodeName();
                if (name.equals("Chroma")) {
                    childNode = node.getFirstChild();
                    while (childNode != null) {
                        childName = childNode.getNodeName();
                        if (childName.equals("Palette")) {
                            this.globalColorTable = this.getColorTable(childNode, "PaletteEntry", false, -1);
                        } else if (childName.equals("BackgroundIndex")) {
                            this.backgroundColorIndex = GIFWritableStreamMetadata.getIntAttribute(childNode, "value", -1, true, true, 0, 255);
                        }
                        childNode = childNode.getNextSibling();
                    }
                } else if (name.equals("Data")) {
                    childNode = node.getFirstChild();
                    while (childNode != null) {
                        childName = childNode.getNodeName();
                        if (childName.equals("BitsPerSample")) {
                            this.colorResolution = GIFWritableStreamMetadata.getIntAttribute(childNode, "value", -1, true, true, 1, 8);
                            break;
                        }
                        childNode = childNode.getNextSibling();
                    }
                } else if (name.equals("Dimension")) {
                    childNode = node.getFirstChild();
                    while (childNode != null) {
                        childName = childNode.getNodeName();
                        if (childName.equals("PixelAspectRatio")) {
                            float aspectRatio = GIFWritableStreamMetadata.getFloatAttribute(childNode, "value");
                            if (aspectRatio == 1.0f) {
                                this.pixelAspectRatio = 0;
                            } else {
                                int ratio = (int)(aspectRatio * 64.0f - 15.0f);
                                this.pixelAspectRatio = Math.max(Math.min(ratio, 255), 0);
                            }
                        } else if (childName.equals("HorizontalScreenSize")) {
                            this.logicalScreenWidth = GIFWritableStreamMetadata.getIntAttribute(childNode, "value", -1, true, true, 1, 65535);
                        } else if (childName.equals("VerticalScreenSize")) {
                            this.logicalScreenHeight = GIFWritableStreamMetadata.getIntAttribute(childNode, "value", -1, true, true, 1, 65535);
                        }
                        childNode = childNode.getNextSibling();
                    }
                } else if (name.equals("Document")) {
                    childNode = node.getFirstChild();
                    while (childNode != null) {
                        childName = childNode.getNodeName();
                        if (childName.equals("FormatVersion")) {
                            String formatVersion = GIFWritableStreamMetadata.getStringAttribute(childNode, "value", null, true, null);
                            int i = 0;
                            while (i < versionStrings.length) {
                                if (formatVersion.equals(versionStrings[i])) {
                                    this.version = formatVersion;
                                    break block27;
                                }
                                ++i;
                            }
                            break;
                        }
                        childNode = childNode.getNextSibling();
                    }
                }
            }
            node = node.getNextSibling();
        }
    }

    public void setFromTree(String formatName, Node root) throws IIOInvalidTreeException {
        this.reset();
        this.mergeTree(formatName, root);
    }
}

