/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;
import jj2000.j2k.io.RandomAccessIO;

public class IISRandomAccessIO
implements RandomAccessIO {
    private ImageInputStream iis;

    public IISRandomAccessIO(ImageInputStream iis) {
        if (iis == null) {
            throw new IllegalArgumentException("iis == null!");
        }
        this.iis = iis;
    }

    public void close() throws IOException {
        this.iis.close();
    }

    public int getPos() throws IOException {
        long pos = this.iis.getStreamPosition();
        return pos > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)pos;
    }

    public void seek(int off) throws IOException {
        this.iis.seek(off);
    }

    public int length() throws IOException {
        long len = this.iis.length();
        if (len != -1L) {
            return len > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)len;
        }
        this.iis.mark();
        int bufLen = 1024;
        byte[] buf = new byte[bufLen];
        long pos = this.iis.getStreamPosition();
        while (pos < Integer.MAX_VALUE) {
            int numRead = this.iis.read(buf, 0, bufLen);
            if (numRead == -1) break;
            pos += (long)numRead;
        }
        this.iis.reset();
        return pos > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)pos;
    }

    public int read() throws IOException {
        return this.iis.read();
    }

    public void readFully(byte[] b, int off, int n) throws IOException {
        this.iis.readFully(b, off, n);
    }

    public int getByteOrdering() {
        return this.iis.getByteOrder() == ByteOrder.BIG_ENDIAN ? 0 : 1;
    }

    public byte readByte() throws IOException {
        return this.iis.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.iis.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.iis.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.iis.readUnsignedShort();
    }

    public int readInt() throws IOException {
        return this.iis.readInt();
    }

    public long readUnsignedInt() throws IOException {
        return this.iis.readUnsignedInt();
    }

    public long readLong() throws IOException {
        return this.iis.readLong();
    }

    public float readFloat() throws IOException {
        return this.iis.readFloat();
    }

    public double readDouble() throws IOException {
        return this.iis.readDouble();
    }

    public int skipBytes(int n) throws IOException {
        return this.iis.skipBytes(n);
    }

    public void flush() {
    }

    public void write(int b) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    public void writeByte(int v) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    public void writeShort(int v) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    public void writeInt(int v) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    public void writeLong(long v) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    public void writeFloat(float v) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    public void writeDouble(double v) throws IOException {
        throw new IOException("Writing is not supported!");
    }
}

