/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriterCodecLib;
import java.awt.image.SampleModel;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;

public class J2KImageWriterCodecLibSpi
extends ImageWriterSpi {
    private static String[] readerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderCodecLibSpi"};
    private static String[] formatNames = new String[]{"jpeg 2000", "JPEG 2000", "jpeg2000", "JPEG2000"};
    private static String[] extensions = new String[]{"jp2"};
    private static String[] mimeTypes = new String[]{"image/jp2", "image/jpeg2000"};
    private boolean registered = false;

    public J2KImageWriterCodecLibSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), formatNames, extensions, mimeTypes, "com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriterCodecLib", STANDARD_OUTPUT_TYPE, readerSpiNames, false, null, null, null, null, true, "com_sun_media_imageio_plugins_jpeg2000_image_1.0", "com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadataFormat", null, null);
    }

    public String getDescription(Locale locale) {
        String desc = String.valueOf(PackageUtil.getSpecificationTitle()) + " natively-accelerated JPEG 2000 Image Writer";
        return desc;
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        if (this.registered) {
            return;
        }
        this.registered = true;
        if (!PackageUtil.isCodecLibAvailable()) {
            registry.deregisterServiceProvider(this);
        } else {
            Object javaWriterSPI;
            Class<?> javaWriterSPIClass = null;
            try {
                javaWriterSPIClass = Class.forName("com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriterSpi");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (javaWriterSPIClass != null && (javaWriterSPI = registry.getServiceProviderByClass(javaWriterSPIClass)) != null) {
                registry.setOrdering(category, this, javaWriterSPI);
            }
        }
    }

    public boolean canEncodeImage(ImageTypeSpecifier type) {
        SampleModel sm = type.getSampleModel();
        if (sm.getNumBands() > 16384) {
            return false;
        }
        return sm.getDataType() >= 0 && sm.getDataType() <= 3;
    }

    public ImageWriter createWriterInstance(Object extension) throws IIOException {
        return new J2KImageWriterCodecLib(this);
    }
}

