/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UUIDListBox
extends Box {
    private short num;
    private byte[][] uuids;

    public UUIDListBox(short num, byte[][] uuids) {
        super(10 + (uuids.length << 4), 1970041716, null);
        this.num = num;
        this.uuids = uuids;
    }

    public UUIDListBox(byte[] data) {
        super(8 + data.length, 1970041716, data);
    }

    public UUIDListBox(Node node) throws IIOInvalidTreeException {
        super(node);
        Node child;
        NodeList children = node.getChildNodes();
        int index = 0;
        int i = 0;
        while (i < children.getLength()) {
            child = children.item(i);
            if ("NumberUUID".equals(child.getNodeName())) {
                this.num = Box.getShortElementValue(child);
                this.uuids = new byte[this.num][];
            }
            ++i;
        }
        i = 0;
        while (i < children.getLength()) {
            child = children.item(i);
            if ("UUID".equals(child.getNodeName()) && index < this.num) {
                this.uuids[index++] = Box.getByteArrayElementValue(child);
            }
            ++i;
        }
    }

    protected void parse(byte[] data) {
        this.num = (short)((data[0] & 0xFF) << 8 | data[1] & 0xFF);
        this.uuids = new byte[this.num][];
        int pos = 2;
        int i = 0;
        while (i < this.num) {
            this.uuids[i] = new byte[16];
            System.arraycopy(data, pos, this.uuids[i], 0, 16);
            pos += 16;
            ++i;
        }
    }

    public IIOMetadataNode getNativeNode() {
        IIOMetadataNode node = new IIOMetadataNode(Box.getName(this.getType()));
        this.setDefaultAttributes(node);
        IIOMetadataNode child = new IIOMetadataNode("NumberUUID");
        child.setUserObject(new Short(this.num));
        child.setNodeValue("" + this.num);
        node.appendChild(child);
        int i = 0;
        while (i < this.num) {
            child = new IIOMetadataNode("UUID");
            child.setUserObject(this.uuids[i]);
            child.setNodeValue(ImageUtil.convertObjectToString(this.uuids[i]));
            node.appendChild(child);
            ++i;
        }
        return node;
    }

    protected void compose() {
        if (this.data != null) {
            return;
        }
        this.data = new byte[2 + this.num * 16];
        this.data[0] = (byte)(this.num >> 8);
        this.data[1] = (byte)(this.num & 0xFF);
        int i = 0;
        int pos = 2;
        while (i < this.num) {
            System.arraycopy(this.uuids[i], 0, this.data, pos, 16);
            pos += 16;
            ++i;
        }
    }
}

