/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image.forwcomptransf;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import java.util.StringTokenizer;
import jj2000.j2k.image.CompTransfSpec;
import jj2000.j2k.wavelet.FilterTypes;
import jj2000.j2k.wavelet.analysis.AnWTFilter;
import jj2000.j2k.wavelet.analysis.AnWTFilterSpec;

public class ForwCompTransfSpec
extends CompTransfSpec
implements FilterTypes {
    private String defaultValue = null;

    public ForwCompTransfSpec(int nt, int nc, byte type, AnWTFilterSpec wfs, J2KImageWriteParamJava wp, String values) {
        super(nt, nc, type);
        int t;
        String param = values;
        this.specified = values;
        if (values == null) {
            AnWTFilter[][] anfilt;
            if (nc < 3) {
                this.setDefault("none");
                return;
            }
            if (wp.getLossless()) {
                this.setDefault("rct");
                return;
            }
            int[] filtType = new int[this.nComp];
            int c = 0;
            while (c < 3) {
                anfilt = (AnWTFilter[][])wfs.getCompDef(c);
                filtType[c] = anfilt[0][0].getFilterType();
                ++c;
            }
            boolean reject = false;
            int c2 = 1;
            while (c2 < 3) {
                if (filtType[c2] != filtType[0]) {
                    reject = true;
                }
                ++c2;
            }
            if (reject) {
                this.setDefault("none");
            } else {
                anfilt = (AnWTFilter[][])wfs.getCompDef(0);
                if (anfilt[0][0].getFilterType() == 0) {
                    this.setDefault("ict");
                } else {
                    this.setDefault("rct");
                }
            }
            int t2 = 0;
            while (t2 < nt) {
                AnWTFilter[][] anfilt2;
                int[] filtType2 = new int[this.nComp];
                c2 = 0;
                while (c2 < 3) {
                    anfilt2 = (AnWTFilter[][])wfs.getTileCompVal(t2, c2);
                    filtType2[c2] = anfilt2[0][0].getFilterType();
                    ++c2;
                }
                boolean reject2 = false;
                int c3 = 1;
                while (c3 < this.nComp) {
                    if (filtType2[c3] != filtType2[0]) {
                        reject2 = true;
                    }
                    ++c3;
                }
                if (reject2) {
                    this.setTileDef(t2, "none");
                } else {
                    anfilt2 = (AnWTFilter[][])wfs.getTileCompVal(t2, 0);
                    if (anfilt2[0][0].getFilterType() == 0) {
                        this.setTileDef(t2, "ict");
                    } else {
                        this.setTileDef(t2, "rct");
                    }
                }
                ++t2;
            }
            return;
        }
        if (param.equalsIgnoreCase("true")) {
            param = "on";
        }
        StringTokenizer stk = new StringTokenizer(param);
        int curSpecType = 0;
        boolean[] tileSpec = null;
        while (stk.hasMoreTokens()) {
            String word = stk.nextToken();
            switch (word.charAt(0)) {
                case 't': {
                    tileSpec = ForwCompTransfSpec.parseIdx(word, this.nTiles);
                    if (curSpecType == 1) {
                        curSpecType = 3;
                        break;
                    }
                    curSpecType = 2;
                    break;
                }
                case 'c': {
                    throw new IllegalArgumentException("Component specific  parameters not allowed with '-Mct' option");
                }
                default: {
                    int i;
                    if (word.equals("off")) {
                        if (curSpecType == 0) {
                            this.setDefault("none");
                        } else if (curSpecType == 2) {
                            i = tileSpec.length - 1;
                            while (i >= 0) {
                                if (tileSpec[i]) {
                                    this.setTileDef(i, "none");
                                }
                                --i;
                            }
                        }
                    } else if (word.equals("on")) {
                        if (nc < 3) {
                            this.setDefault("none");
                            break;
                        }
                        if (curSpecType == 0) {
                            this.setDefault("rct");
                        } else if (curSpecType == 2) {
                            i = tileSpec.length - 1;
                            while (i >= 0) {
                                if (tileSpec[i]) {
                                    if (this.getFilterType(i, wfs) == 1) {
                                        this.setTileDef(i, "rct");
                                    } else {
                                        this.setTileDef(i, "ict");
                                    }
                                }
                                --i;
                            }
                        }
                    } else {
                        throw new IllegalArgumentException("Default parameter of option Mct not recognized: " + param);
                    }
                    curSpecType = 0;
                    tileSpec = null;
                }
            }
        }
        if (this.getDefault() == null) {
            this.setDefault("none");
            t = 0;
            while (t < nt) {
                if (!this.isTileSpecified(t)) {
                    AnWTFilter[][] anfilt;
                    int[] filtType = new int[this.nComp];
                    int c = 0;
                    while (c < 3) {
                        anfilt = (AnWTFilter[][])wfs.getTileCompVal(t, c);
                        filtType[c] = anfilt[0][0].getFilterType();
                        ++c;
                    }
                    boolean reject = false;
                    int c4 = 1;
                    while (c4 < this.nComp) {
                        if (filtType[c4] != filtType[0]) {
                            reject = true;
                        }
                        ++c4;
                    }
                    if (reject) {
                        this.setTileDef(t, "none");
                    } else {
                        anfilt = (AnWTFilter[][])wfs.getTileCompVal(t, 0);
                        if (anfilt[0][0].getFilterType() == 0) {
                            this.setTileDef(t, "ict");
                        } else {
                            this.setTileDef(t, "rct");
                        }
                    }
                }
                ++t;
            }
        }
        t = nt - 1;
        while (t >= 0) {
            block63: {
                block64: {
                    if (((String)this.getTileDef(t)).equals("none")) break block63;
                    if (!((String)this.getTileDef(t)).equals("rct")) break block64;
                    int filterType = this.getFilterType(t, wfs);
                    switch (filterType) {
                        case 1: {
                            break block63;
                        }
                        case 0: {
                            if (this.isTileSpecified(t)) {
                                throw new IllegalArgumentException("Cannot use RCT with 9x7 filter in tile " + t);
                            }
                            this.setTileDef(t, "ict");
                            break block63;
                        }
                        default: {
                            throw new IllegalArgumentException("Default filter is not JPEG 2000 part I compliant");
                        }
                    }
                }
                int filterType = this.getFilterType(t, wfs);
                switch (filterType) {
                    case 1: {
                        if (this.isTileSpecified(t)) {
                            throw new IllegalArgumentException("Cannot use ICT with filter 5x3 in tile " + t);
                        }
                        this.setTileDef(t, "rct");
                        break;
                    }
                    case 0: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Default filter is not JPEG 2000 part I compliant");
                    }
                }
            }
            --t;
        }
    }

    private int getFilterType(int t, AnWTFilterSpec wfs) {
        int[] filtType = new int[this.nComp];
        int c = 0;
        while (c < this.nComp) {
            AnWTFilter[][] anfilt = t == -1 ? (AnWTFilter[][])wfs.getCompDef(c) : (AnWTFilter[][])wfs.getTileCompVal(t, c);
            filtType[c] = anfilt[0][0].getFilterType();
            ++c;
        }
        boolean reject = false;
        int c2 = 1;
        while (c2 < this.nComp) {
            if (filtType[c2] != filtType[0]) {
                reject = true;
            }
            ++c2;
        }
        if (reject) {
            throw new IllegalArgumentException("Can not use component transformation when components do not use the same filters");
        }
        return filtType[0];
    }
}

