/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.imgcodecs;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.MatOfDouble;
import org.opencv.core.MatOfInt;
import org.opencv.core.Range;
import org.opencv.utils.Converters;

public class Imgcodecs {
    public static final int DICOM_CP_UNKNOWN = 0;
    public static final int DICOM_CP_JPG = 1;
    public static final int DICOM_CP_JPLS = 2;
    public static final int DICOM_CP_J2K = 3;
    public static final int DICOM_FLAG_DEFAULT = -1;
    public static final int DICOM_FLAG_UNSIGNED = 0;
    public static final int DICOM_FLAG_SIGNED = 1;
    public static final int DICOM_FLAG_YBR = 2;
    public static final int DICOM_FLAG_BIGENDIAN = 4;
    public static final int DICOM_FLAG_FLOAT = 16;
    public static final int DICOM_FLAG_RLE = 32;
    public static final int DICOM_FLAG_FORCE_RGB_CONVERSION = 64;
    public static final int DICOM_PARAM_IMREAD = 0;
    public static final int DICOM_PARAM_DCM_IMREAD = 1;
    public static final int DICOM_PARAM_WIDTH = 2;
    public static final int DICOM_PARAM_HEIGHT = 3;
    public static final int DICOM_PARAM_COMPRESSION = 4;
    public static final int DICOM_PARAM_COMPONENTS = 5;
    public static final int DICOM_PARAM_BITS_PER_SAMPLE = 6;
    public static final int DICOM_PARAM_INTERLEAVE_MODE = 7;
    public static final int DICOM_PARAM_STREAM_VR = 8;
    public static final int DICOM_PARAM_COLOR_MODEL = 9;
    public static final int DICOM_PARAM_JPEG_MODE = 10;
    public static final int DICOM_PARAM_JPEGLS_LOSSY_ERROR = 11;
    public static final int DICOM_PARAM_J2K_COMPRESSION_FACTOR = 12;
    public static final int DICOM_PARAM_JPEG_QUALITY = 13;
    public static final int DICOM_PARAM_JPEG_PREDICTION = 14;
    public static final int DICOM_PARAM_JPEG_PT_TRANSFORM = 15;
    public static final int JPEG_baseline = 0;
    public static final int JPEG_sequential = 1;
    public static final int JPEG_spectralSelection = 2;
    public static final int JPEG_progressive = 3;
    public static final int JPEG_lossless = 4;
    public static final int POS_IMAGE_DESCRIPTION = 0;
    public static final int POS_MAKE = 1;
    public static final int POS_MODEL = 2;
    public static final int POS_ORIENTATION = 3;
    public static final int POS_XRESOLUTION = 4;
    public static final int POS_YRESOLUTION = 5;
    public static final int POS_RESOLUTION_UNIT = 6;
    public static final int POS_SOFTWARE = 7;
    public static final int POS_DATE_TIME = 8;
    public static final int POS_COPYRIGHT = 9;
    public static final int IMREAD_UNCHANGED = -1;
    public static final int IMREAD_GRAYSCALE = 0;
    public static final int IMREAD_COLOR = 1;
    public static final int IMREAD_ANYDEPTH = 2;
    public static final int IMREAD_ANYCOLOR = 4;
    public static final int IMREAD_LOAD_GDAL = 8;
    public static final int IMREAD_REDUCED_GRAYSCALE_2 = 16;
    public static final int IMREAD_REDUCED_COLOR_2 = 17;
    public static final int IMREAD_REDUCED_GRAYSCALE_4 = 32;
    public static final int IMREAD_REDUCED_COLOR_4 = 33;
    public static final int IMREAD_REDUCED_GRAYSCALE_8 = 64;
    public static final int IMREAD_REDUCED_COLOR_8 = 65;
    public static final int IMREAD_IGNORE_ORIENTATION = 128;
    public static final int IMWRITE_EXR_COMPRESSION_NO = 0;
    public static final int IMWRITE_EXR_COMPRESSION_RLE = 1;
    public static final int IMWRITE_EXR_COMPRESSION_ZIPS = 2;
    public static final int IMWRITE_EXR_COMPRESSION_ZIP = 3;
    public static final int IMWRITE_EXR_COMPRESSION_PIZ = 4;
    public static final int IMWRITE_EXR_COMPRESSION_PXR24 = 5;
    public static final int IMWRITE_EXR_COMPRESSION_B44 = 6;
    public static final int IMWRITE_EXR_COMPRESSION_B44A = 7;
    public static final int IMWRITE_EXR_COMPRESSION_DWAA = 8;
    public static final int IMWRITE_EXR_COMPRESSION_DWAB = 9;
    public static final int IMWRITE_EXR_TYPE_HALF = 1;
    public static final int IMWRITE_EXR_TYPE_FLOAT = 2;
    public static final int IMWRITE_JPEG_QUALITY = 1;
    public static final int IMWRITE_JPEG_PROGRESSIVE = 2;
    public static final int IMWRITE_JPEG_OPTIMIZE = 3;
    public static final int IMWRITE_JPEG_RST_INTERVAL = 4;
    public static final int IMWRITE_JPEG_LUMA_QUALITY = 5;
    public static final int IMWRITE_JPEG_CHROMA_QUALITY = 6;
    public static final int IMWRITE_JPEG_SAMPLING_FACTOR = 7;
    public static final int IMWRITE_PNG_COMPRESSION = 16;
    public static final int IMWRITE_PNG_STRATEGY = 17;
    public static final int IMWRITE_PNG_BILEVEL = 18;
    public static final int IMWRITE_PXM_BINARY = 32;
    public static final int IMWRITE_EXR_TYPE = 48;
    public static final int IMWRITE_EXR_COMPRESSION = 49;
    public static final int IMWRITE_EXR_DWA_COMPRESSION_LEVEL = 50;
    public static final int IMWRITE_WEBP_QUALITY = 64;
    public static final int IMWRITE_HDR_COMPRESSION = 80;
    public static final int IMWRITE_PAM_TUPLETYPE = 128;
    public static final int IMWRITE_TIFF_RESUNIT = 256;
    public static final int IMWRITE_TIFF_XDPI = 257;
    public static final int IMWRITE_TIFF_YDPI = 258;
    public static final int IMWRITE_TIFF_COMPRESSION = 259;
    public static final int IMWRITE_JPEG2000_COMPRESSION_X1000 = 272;
    public static final int IMWRITE_AVIF_QUALITY = 512;
    public static final int IMWRITE_AVIF_DEPTH = 513;
    public static final int IMWRITE_AVIF_SPEED = 514;
    public static final int IMWRITE_HDR_COMPRESSION_NONE = 0;
    public static final int IMWRITE_HDR_COMPRESSION_RLE = 1;
    public static final int IMWRITE_JPEG_SAMPLING_FACTOR_411 = 0x411111;
    public static final int IMWRITE_JPEG_SAMPLING_FACTOR_420 = 0x221111;
    public static final int IMWRITE_JPEG_SAMPLING_FACTOR_422 = 0x211111;
    public static final int IMWRITE_JPEG_SAMPLING_FACTOR_440 = 0x121111;
    public static final int IMWRITE_JPEG_SAMPLING_FACTOR_444 = 0x111111;
    public static final int IMWRITE_PAM_FORMAT_NULL = 0;
    public static final int IMWRITE_PAM_FORMAT_BLACKANDWHITE = 1;
    public static final int IMWRITE_PAM_FORMAT_GRAYSCALE = 2;
    public static final int IMWRITE_PAM_FORMAT_GRAYSCALE_ALPHA = 3;
    public static final int IMWRITE_PAM_FORMAT_RGB = 4;
    public static final int IMWRITE_PAM_FORMAT_RGB_ALPHA = 5;
    public static final int IMWRITE_PNG_STRATEGY_DEFAULT = 0;
    public static final int IMWRITE_PNG_STRATEGY_FILTERED = 1;
    public static final int IMWRITE_PNG_STRATEGY_HUFFMAN_ONLY = 2;
    public static final int IMWRITE_PNG_STRATEGY_RLE = 3;
    public static final int IMWRITE_PNG_STRATEGY_FIXED = 4;
    public static final int EPI_Unknown = 0;
    public static final int EPI_Missing = 1;
    public static final int EPI_Monochrome1 = 2;
    public static final int EPI_Monochrome2 = 3;
    public static final int EPI_PaletteColor = 4;
    public static final int EPI_RGB = 5;
    public static final int EPI_HSV = 6;
    public static final int EPI_ARGB = 7;
    public static final int EPI_CMYK = 8;
    public static final int EPI_YBR_Full = 9;
    public static final int EPI_YBR_Full_422 = 10;
    public static final int EPI_YBR_Partial_422 = 11;
    public static final int ILV_NONE = 0;
    public static final int ILV_LINE = 1;
    public static final int ILV_SAMPLE = 2;

    public static Mat imread(String filename, List<String> tags, int flags) {
        return new Mat(Imgcodecs.imread_0(filename, tags, flags));
    }

    public static Mat imread(String filename, List<String> tags) {
        return new Mat(Imgcodecs.imread_1(filename, tags));
    }

    public static Mat dicomJpgFileRead(String filename, MatOfDouble segposition, MatOfDouble seglength, int dicomflags, int flags) {
        MatOfDouble segposition_mat = segposition;
        MatOfDouble seglength_mat = seglength;
        return new Mat(Imgcodecs.dicomJpgFileRead_0(filename, segposition_mat.nativeObj, seglength_mat.nativeObj, dicomflags, flags));
    }

    public static Mat dicomJpgFileRead(String filename, MatOfDouble segposition, MatOfDouble seglength, int dicomflags) {
        MatOfDouble segposition_mat = segposition;
        MatOfDouble seglength_mat = seglength;
        return new Mat(Imgcodecs.dicomJpgFileRead_1(filename, segposition_mat.nativeObj, seglength_mat.nativeObj, dicomflags));
    }

    public static Mat dicomJpgFileRead(String filename, MatOfDouble segposition, MatOfDouble seglength) {
        MatOfDouble segposition_mat = segposition;
        MatOfDouble seglength_mat = seglength;
        return new Mat(Imgcodecs.dicomJpgFileRead_2(filename, segposition_mat.nativeObj, seglength_mat.nativeObj));
    }

    public static Mat dicomJpgMatRead(Mat buf, int dicomflags, int flags) {
        return new Mat(Imgcodecs.dicomJpgMatRead_0(buf.nativeObj, dicomflags, flags));
    }

    public static Mat dicomJpgMatRead(Mat buf, int dicomflags) {
        return new Mat(Imgcodecs.dicomJpgMatRead_1(buf.nativeObj, dicomflags));
    }

    public static Mat dicomJpgMatRead(Mat buf) {
        return new Mat(Imgcodecs.dicomJpgMatRead_2(buf.nativeObj));
    }

    public static Mat dicomRawFileRead(String filename, MatOfDouble segposition, MatOfDouble seglength, MatOfInt dicomparams, String colormodel) {
        MatOfDouble segposition_mat = segposition;
        MatOfDouble seglength_mat = seglength;
        MatOfInt dicomparams_mat = dicomparams;
        return new Mat(Imgcodecs.dicomRawFileRead_0(filename, segposition_mat.nativeObj, seglength_mat.nativeObj, dicomparams_mat.nativeObj, colormodel));
    }

    public static Mat dicomRawMatRead(Mat buf, MatOfInt dicomParams, String colormodel) {
        MatOfInt dicomParams_mat = dicomParams;
        return new Mat(Imgcodecs.dicomRawMatRead_0(buf.nativeObj, dicomParams_mat.nativeObj, colormodel));
    }

    public static Mat dicomJpgWrite(Mat image, MatOfInt dicomParams, String colormodel) {
        MatOfInt dicomParams_mat = dicomParams;
        return new Mat(Imgcodecs.dicomJpgWrite_0(image.nativeObj, dicomParams_mat.nativeObj, colormodel));
    }

    public static boolean imreadmulti(String filename, List<Mat> mats, int flags) {
        Mat mats_mat = new Mat();
        boolean retVal = Imgcodecs.imreadmulti_0(filename, mats_mat.nativeObj, flags);
        Converters.Mat_to_vector_Mat(mats_mat, mats);
        mats_mat.release();
        return retVal;
    }

    public static boolean imreadmulti(String filename, List<Mat> mats) {
        Mat mats_mat = new Mat();
        boolean retVal = Imgcodecs.imreadmulti_1(filename, mats_mat.nativeObj);
        Converters.Mat_to_vector_Mat(mats_mat, mats);
        mats_mat.release();
        return retVal;
    }

    public static boolean imreadmulti(String filename, List<Mat> mats, int start, int count, int flags) {
        Mat mats_mat = new Mat();
        boolean retVal = Imgcodecs.imreadmulti_2(filename, mats_mat.nativeObj, start, count, flags);
        Converters.Mat_to_vector_Mat(mats_mat, mats);
        mats_mat.release();
        return retVal;
    }

    public static boolean imreadmulti(String filename, List<Mat> mats, int start, int count) {
        Mat mats_mat = new Mat();
        boolean retVal = Imgcodecs.imreadmulti_3(filename, mats_mat.nativeObj, start, count);
        Converters.Mat_to_vector_Mat(mats_mat, mats);
        mats_mat.release();
        return retVal;
    }

    public static long imcount(String filename, int flags) {
        return Imgcodecs.imcount_0(filename, flags);
    }

    public static long imcount(String filename) {
        return Imgcodecs.imcount_1(filename);
    }

    public static boolean imwrite(String filename, Mat img, MatOfInt params) {
        MatOfInt params_mat = params;
        return Imgcodecs.imwrite_0(filename, img.nativeObj, params_mat.nativeObj);
    }

    public static boolean imwrite(String filename, Mat img) {
        return Imgcodecs.imwrite_1(filename, img.nativeObj);
    }

    public static boolean imwritemulti(String filename, List<Mat> img, MatOfInt params) {
        Mat img_mat = Converters.vector_Mat_to_Mat(img);
        MatOfInt params_mat = params;
        return Imgcodecs.imwritemulti_0(filename, img_mat.nativeObj, params_mat.nativeObj);
    }

    public static boolean imwritemulti(String filename, List<Mat> img) {
        Mat img_mat = Converters.vector_Mat_to_Mat(img);
        return Imgcodecs.imwritemulti_1(filename, img_mat.nativeObj);
    }

    public static Mat imdecode(Mat buf, int flags) {
        return new Mat(Imgcodecs.imdecode_0(buf.nativeObj, flags));
    }

    public static boolean imdecodemulti(Mat buf, int flags, List<Mat> mats, Range range) {
        Mat mats_mat = new Mat();
        boolean retVal = Imgcodecs.imdecodemulti_0(buf.nativeObj, flags, mats_mat.nativeObj, range.start, range.end);
        Converters.Mat_to_vector_Mat(mats_mat, mats);
        mats_mat.release();
        return retVal;
    }

    public static boolean imdecodemulti(Mat buf, int flags, List<Mat> mats) {
        Mat mats_mat = new Mat();
        boolean retVal = Imgcodecs.imdecodemulti_1(buf.nativeObj, flags, mats_mat.nativeObj);
        Converters.Mat_to_vector_Mat(mats_mat, mats);
        mats_mat.release();
        return retVal;
    }

    public static boolean imencode(String ext, Mat img, MatOfByte buf, MatOfInt params) {
        MatOfByte buf_mat = buf;
        MatOfInt params_mat = params;
        return Imgcodecs.imencode_0(ext, img.nativeObj, buf_mat.nativeObj, params_mat.nativeObj);
    }

    public static boolean imencode(String ext, Mat img, MatOfByte buf) {
        MatOfByte buf_mat = buf;
        return Imgcodecs.imencode_1(ext, img.nativeObj, buf_mat.nativeObj);
    }

    public static boolean haveImageReader(String filename) {
        return Imgcodecs.haveImageReader_0(filename);
    }

    public static boolean haveImageWriter(String filename) {
        return Imgcodecs.haveImageWriter_0(filename);
    }

    private static native long imread_0(String var0, List<String> var1, int var2);

    private static native long imread_1(String var0, List<String> var1);

    private static native long dicomJpgFileRead_0(String var0, long var1, long var3, int var5, int var6);

    private static native long dicomJpgFileRead_1(String var0, long var1, long var3, int var5);

    private static native long dicomJpgFileRead_2(String var0, long var1, long var3);

    private static native long dicomJpgMatRead_0(long var0, int var2, int var3);

    private static native long dicomJpgMatRead_1(long var0, int var2);

    private static native long dicomJpgMatRead_2(long var0);

    private static native long dicomRawFileRead_0(String var0, long var1, long var3, long var5, String var7);

    private static native long dicomRawMatRead_0(long var0, long var2, String var4);

    private static native long dicomJpgWrite_0(long var0, long var2, String var4);

    private static native boolean imreadmulti_0(String var0, long var1, int var3);

    private static native boolean imreadmulti_1(String var0, long var1);

    private static native boolean imreadmulti_2(String var0, long var1, int var3, int var4, int var5);

    private static native boolean imreadmulti_3(String var0, long var1, int var3, int var4);

    private static native long imcount_0(String var0, int var1);

    private static native long imcount_1(String var0);

    private static native boolean imwrite_0(String var0, long var1, long var3);

    private static native boolean imwrite_1(String var0, long var1);

    private static native boolean imwritemulti_0(String var0, long var1, long var3);

    private static native boolean imwritemulti_1(String var0, long var1);

    private static native long imdecode_0(long var0, int var2);

    private static native boolean imdecodemulti_0(long var0, int var2, long var3, int var5, int var6);

    private static native boolean imdecodemulti_1(long var0, int var2, long var3);

    private static native boolean imencode_0(String var0, long var1, long var3, long var5);

    private static native boolean imencode_1(String var0, long var1, long var3);

    private static native boolean haveImageReader_0(String var0);

    private static native boolean haveImageWriter_0(String var0);
}

