/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.util;

import java.util.HashMap;
import java.util.Map;
import org.weasis.core.util.StringUtil;

public final class EscapeChars {
    public static final String AMPERSAND = "&amp;";
    public static final String OPEN_TAG = "&lt;";
    public static final String CLOSE_TAG = "&gt;";
    private static final HashMap<Character, String> tagEncodeChars = new HashMap();
    private static final HashMap<Character, String> xmlEncodeChars;
    private static final HashMap<Character, String> htmlEncodeChars;

    private static boolean isInvalidXml(char c) {
        return !(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd');
    }

    private static String encode(String aText, Map<Character, String> table) {
        int diff;
        if (!StringUtil.hasText(aText)) {
            return "";
        }
        StringBuilder buffer = null;
        int last = -1;
        char[] charArray = aText.toCharArray();
        boolean xml = table == xmlEncodeChars;
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (table.containsKey(Character.valueOf(c))) {
                if (buffer == null) {
                    buffer = new StringBuilder(aText.length());
                }
                if ((diff = i - (last + 1)) > 0) {
                    buffer.append(charArray, last + 1, diff);
                }
                buffer.append(table.get(Character.valueOf(c)));
                last = i;
                continue;
            }
            if (!xml || !EscapeChars.isInvalidXml(c)) continue;
            if (buffer == null) {
                buffer = new StringBuilder(aText.length());
            }
            if ((diff = i - (last + 1)) > 0) {
                buffer.append(charArray, last + 1, diff);
            }
            last = i;
        }
        if (buffer == null) {
            return aText;
        }
        diff = charArray.length - (last + 1);
        if (diff > 0) {
            buffer.append(charArray, last + 1, diff);
        }
        return buffer.toString();
    }

    private EscapeChars() {
    }

    public static String forHTML(String aText) {
        return EscapeChars.encode(aText, htmlEncodeChars);
    }

    public static String forUrlAmpersand(String aURL) {
        return aURL.replace("&", AMPERSAND);
    }

    public static String forXML(String aText) {
        return EscapeChars.encode(aText, xmlEncodeChars);
    }

    public static String toDisableTags(String aText) {
        return EscapeChars.encode(aText, tagEncodeChars);
    }

    public static String[] convertToLines(String unformatted) {
        if (unformatted == null) {
            return new String[0];
        }
        int lfPos = unformatted.indexOf(10);
        int crPos = unformatted.indexOf(13);
        if (crPos < 0 && lfPos < 0) {
            return new String[]{unformatted};
        }
        String regex = lfPos == -1 ? "\r" : (crPos == -1 ? "\n" : (crPos < lfPos ? "\r\n" : "\n\r"));
        return unformatted.split(regex);
    }

    static {
        tagEncodeChars.put(Character.valueOf('<'), OPEN_TAG);
        tagEncodeChars.put(Character.valueOf('>'), CLOSE_TAG);
        xmlEncodeChars = new HashMap();
        xmlEncodeChars.putAll(tagEncodeChars);
        xmlEncodeChars.put(Character.valueOf('&'), AMPERSAND);
        xmlEncodeChars.put(Character.valueOf('\"'), "&quot;");
        xmlEncodeChars.put(Character.valueOf('\''), "&apos;");
        htmlEncodeChars = new HashMap();
        htmlEncodeChars.putAll(xmlEncodeChars);
        htmlEncodeChars.put(Character.valueOf('\''), "&#39;");
        htmlEncodeChars.put(Character.valueOf('\u0152'), "&OElig;");
        htmlEncodeChars.put(Character.valueOf('\u0153'), "&oelig;");
        htmlEncodeChars.put(Character.valueOf('\u0160'), "&Scaron;");
        htmlEncodeChars.put(Character.valueOf('\u0161'), "&scaron;");
        htmlEncodeChars.put(Character.valueOf('\u0178'), "&Yuml;");
        htmlEncodeChars.put(Character.valueOf('\u02c6'), "&circ;");
        htmlEncodeChars.put(Character.valueOf('\u02dc'), "&tilde;");
        htmlEncodeChars.put(Character.valueOf('\u2002'), "&ensp;");
        htmlEncodeChars.put(Character.valueOf('\u2003'), "&emsp;");
        htmlEncodeChars.put(Character.valueOf('\u2009'), "&thinsp;");
        htmlEncodeChars.put(Character.valueOf('\u200c'), "&zwnj;");
        htmlEncodeChars.put(Character.valueOf('\u200d'), "&zwj;");
        htmlEncodeChars.put(Character.valueOf('\u200e'), "&lrm;");
        htmlEncodeChars.put(Character.valueOf('\u200f'), "&rlm;");
        htmlEncodeChars.put(Character.valueOf('\u2013'), "&ndash;");
        htmlEncodeChars.put(Character.valueOf('\u2014'), "&mdash;");
        htmlEncodeChars.put(Character.valueOf('\u2018'), "&lsquo;");
        htmlEncodeChars.put(Character.valueOf('\u2019'), "&rsquo;");
        htmlEncodeChars.put(Character.valueOf('\u201a'), "&sbquo;");
        htmlEncodeChars.put(Character.valueOf('\u201c'), "&ldquo;");
        htmlEncodeChars.put(Character.valueOf('\u201d'), "&rdquo;");
        htmlEncodeChars.put(Character.valueOf('\u201e'), "&bdquo;");
        htmlEncodeChars.put(Character.valueOf('\u2020'), "&dagger;");
        htmlEncodeChars.put(Character.valueOf('\u2021'), "&Dagger;");
        htmlEncodeChars.put(Character.valueOf('\u2030'), "&permil;");
        htmlEncodeChars.put(Character.valueOf('\u2039'), "&lsaquo;");
        htmlEncodeChars.put(Character.valueOf('\u203a'), "&rsaquo;");
        htmlEncodeChars.put(Character.valueOf('\u20ac'), "&euro;");
        htmlEncodeChars.put(Character.valueOf('\u00a0'), "&nbsp;");
        htmlEncodeChars.put(Character.valueOf('\u00a1'), "&iexcl;");
        htmlEncodeChars.put(Character.valueOf('\u00a2'), "&cent;");
        htmlEncodeChars.put(Character.valueOf('\u00a3'), "&pound;");
        htmlEncodeChars.put(Character.valueOf('\u00a4'), "&curren;");
        htmlEncodeChars.put(Character.valueOf('\u00a5'), "&yen;");
        htmlEncodeChars.put(Character.valueOf('\u00a6'), "&brvbar;");
        htmlEncodeChars.put(Character.valueOf('\u00a7'), "&sect;");
        htmlEncodeChars.put(Character.valueOf('\u00a8'), "&uml;");
        htmlEncodeChars.put(Character.valueOf('\u00a9'), "&copy;");
        htmlEncodeChars.put(Character.valueOf('\u00aa'), "&ordf;");
        htmlEncodeChars.put(Character.valueOf('\u00ab'), "&laquo;");
        htmlEncodeChars.put(Character.valueOf('\u00ac'), "&not;");
        htmlEncodeChars.put(Character.valueOf('\u00ad'), "&shy;");
        htmlEncodeChars.put(Character.valueOf('\u00ae'), "&reg;");
        htmlEncodeChars.put(Character.valueOf('\u00af'), "&macr;");
        htmlEncodeChars.put(Character.valueOf('\u00b0'), "&deg;");
        htmlEncodeChars.put(Character.valueOf('\u00b1'), "&plusmn;");
        htmlEncodeChars.put(Character.valueOf('\u00b2'), "&sup2;");
        htmlEncodeChars.put(Character.valueOf('\u00b3'), "&sup3;");
        htmlEncodeChars.put(Character.valueOf('\u00b4'), "&acute;");
        htmlEncodeChars.put(Character.valueOf('\u00b5'), "&micro;");
        htmlEncodeChars.put(Character.valueOf('\u00b6'), "&para;");
        htmlEncodeChars.put(Character.valueOf('\u00b7'), "&middot;");
        htmlEncodeChars.put(Character.valueOf('\u00b8'), "&cedil;");
        htmlEncodeChars.put(Character.valueOf('\u00b9'), "&sup1;");
        htmlEncodeChars.put(Character.valueOf('\u00ba'), "&ordm;");
        htmlEncodeChars.put(Character.valueOf('\u00bb'), "&raquo;");
        htmlEncodeChars.put(Character.valueOf('\u00bc'), "&frac14;");
        htmlEncodeChars.put(Character.valueOf('\u00bd'), "&frac12;");
        htmlEncodeChars.put(Character.valueOf('\u00be'), "&frac34;");
        htmlEncodeChars.put(Character.valueOf('\u00bf'), "&iquest;");
        htmlEncodeChars.put(Character.valueOf('\u00c0'), "&Agrave;");
        htmlEncodeChars.put(Character.valueOf('\u00c1'), "&Aacute;");
        htmlEncodeChars.put(Character.valueOf('\u00c2'), "&Acirc;");
        htmlEncodeChars.put(Character.valueOf('\u00c3'), "&Atilde;");
        htmlEncodeChars.put(Character.valueOf('\u00c4'), "&Auml;");
        htmlEncodeChars.put(Character.valueOf('\u00c5'), "&Aring;");
        htmlEncodeChars.put(Character.valueOf('\u00c6'), "&AElig;");
        htmlEncodeChars.put(Character.valueOf('\u00c7'), "&Ccedil;");
        htmlEncodeChars.put(Character.valueOf('\u00c8'), "&Egrave;");
        htmlEncodeChars.put(Character.valueOf('\u00c9'), "&Eacute;");
        htmlEncodeChars.put(Character.valueOf('\u00ca'), "&Ecirc;");
        htmlEncodeChars.put(Character.valueOf('\u00cb'), "&Euml;");
        htmlEncodeChars.put(Character.valueOf('\u00cc'), "&Igrave;");
        htmlEncodeChars.put(Character.valueOf('\u00cd'), "&Iacute;");
        htmlEncodeChars.put(Character.valueOf('\u00ce'), "&Icirc;");
        htmlEncodeChars.put(Character.valueOf('\u00cf'), "&Iuml;");
        htmlEncodeChars.put(Character.valueOf('\u00d0'), "&ETH;");
        htmlEncodeChars.put(Character.valueOf('\u00d1'), "&Ntilde;");
        htmlEncodeChars.put(Character.valueOf('\u00d2'), "&Ograve;");
        htmlEncodeChars.put(Character.valueOf('\u00d3'), "&Oacute;");
        htmlEncodeChars.put(Character.valueOf('\u00d4'), "&Ocirc;");
        htmlEncodeChars.put(Character.valueOf('\u00d5'), "&Otilde;");
        htmlEncodeChars.put(Character.valueOf('\u00d6'), "&Ouml;");
        htmlEncodeChars.put(Character.valueOf('\u00d7'), "&times;");
        htmlEncodeChars.put(Character.valueOf('\u00d8'), "&Oslash;");
        htmlEncodeChars.put(Character.valueOf('\u00d9'), "&Ugrave;");
        htmlEncodeChars.put(Character.valueOf('\u00da'), "&Uacute;");
        htmlEncodeChars.put(Character.valueOf('\u00db'), "&Ucirc;");
        htmlEncodeChars.put(Character.valueOf('\u00dc'), "&Uuml;");
        htmlEncodeChars.put(Character.valueOf('\u00dd'), "&Yacute;");
        htmlEncodeChars.put(Character.valueOf('\u00de'), "&THORN;");
        htmlEncodeChars.put(Character.valueOf('\u00df'), "&szlig;");
        htmlEncodeChars.put(Character.valueOf('\u00e0'), "&agrave;");
        htmlEncodeChars.put(Character.valueOf('\u00e1'), "&aacute;");
        htmlEncodeChars.put(Character.valueOf('\u00e2'), "&acirc;");
        htmlEncodeChars.put(Character.valueOf('\u00e3'), "&atilde;");
        htmlEncodeChars.put(Character.valueOf('\u00e4'), "&auml;");
        htmlEncodeChars.put(Character.valueOf('\u00e5'), "&aring;");
        htmlEncodeChars.put(Character.valueOf('\u00e6'), "&aelig;");
        htmlEncodeChars.put(Character.valueOf('\u00e7'), "&ccedil;");
        htmlEncodeChars.put(Character.valueOf('\u00e8'), "&egrave;");
        htmlEncodeChars.put(Character.valueOf('\u00e9'), "&eacute;");
        htmlEncodeChars.put(Character.valueOf('\u00ea'), "&ecirc;");
        htmlEncodeChars.put(Character.valueOf('\u00eb'), "&euml;");
        htmlEncodeChars.put(Character.valueOf('\u00ec'), "&igrave;");
        htmlEncodeChars.put(Character.valueOf('\u00ed'), "&iacute;");
        htmlEncodeChars.put(Character.valueOf('\u00ee'), "&icirc;");
        htmlEncodeChars.put(Character.valueOf('\u00ef'), "&iuml;");
        htmlEncodeChars.put(Character.valueOf('\u00f0'), "&eth;");
        htmlEncodeChars.put(Character.valueOf('\u00f1'), "&ntilde;");
        htmlEncodeChars.put(Character.valueOf('\u00f2'), "&ograve;");
        htmlEncodeChars.put(Character.valueOf('\u00f3'), "&oacute;");
        htmlEncodeChars.put(Character.valueOf('\u00f4'), "&ocirc;");
        htmlEncodeChars.put(Character.valueOf('\u00f5'), "&otilde;");
        htmlEncodeChars.put(Character.valueOf('\u00f6'), "&ouml;");
        htmlEncodeChars.put(Character.valueOf('\u00f7'), "&divide;");
        htmlEncodeChars.put(Character.valueOf('\u00f8'), "&oslash;");
        htmlEncodeChars.put(Character.valueOf('\u00f9'), "&ugrave;");
        htmlEncodeChars.put(Character.valueOf('\u00fa'), "&uacute;");
        htmlEncodeChars.put(Character.valueOf('\u00fb'), "&ucirc;");
        htmlEncodeChars.put(Character.valueOf('\u00fc'), "&uuml;");
        htmlEncodeChars.put(Character.valueOf('\u00fd'), "&yacute;");
        htmlEncodeChars.put(Character.valueOf('\u00fe'), "&thorn;");
        htmlEncodeChars.put(Character.valueOf('\u00ff'), "&yuml;");
        htmlEncodeChars.put(Character.valueOf('\u0192'), "&fnof;");
        htmlEncodeChars.put(Character.valueOf('\u0391'), "&Alpha;");
        htmlEncodeChars.put(Character.valueOf('\u0392'), "&Beta;");
        htmlEncodeChars.put(Character.valueOf('\u0393'), "&Gamma;");
        htmlEncodeChars.put(Character.valueOf('\u0394'), "&Delta;");
        htmlEncodeChars.put(Character.valueOf('\u0395'), "&Epsilon;");
        htmlEncodeChars.put(Character.valueOf('\u0396'), "&Zeta;");
        htmlEncodeChars.put(Character.valueOf('\u0397'), "&Eta;");
        htmlEncodeChars.put(Character.valueOf('\u0398'), "&Theta;");
        htmlEncodeChars.put(Character.valueOf('\u0399'), "&Iota;");
        htmlEncodeChars.put(Character.valueOf('\u039a'), "&Kappa;");
        htmlEncodeChars.put(Character.valueOf('\u039b'), "&Lambda;");
        htmlEncodeChars.put(Character.valueOf('\u039c'), "&Mu;");
        htmlEncodeChars.put(Character.valueOf('\u039d'), "&Nu;");
        htmlEncodeChars.put(Character.valueOf('\u039e'), "&Xi;");
        htmlEncodeChars.put(Character.valueOf('\u039f'), "&Omicron;");
        htmlEncodeChars.put(Character.valueOf('\u03a0'), "&Pi;");
        htmlEncodeChars.put(Character.valueOf('\u03a1'), "&Rho;");
        htmlEncodeChars.put(Character.valueOf('\u03a3'), "&Sigma;");
        htmlEncodeChars.put(Character.valueOf('\u03a4'), "&Tau;");
        htmlEncodeChars.put(Character.valueOf('\u03a5'), "&Upsilon;");
        htmlEncodeChars.put(Character.valueOf('\u03a6'), "&Phi;");
        htmlEncodeChars.put(Character.valueOf('\u03a7'), "&Chi;");
        htmlEncodeChars.put(Character.valueOf('\u03a8'), "&Psi;");
        htmlEncodeChars.put(Character.valueOf('\u03a9'), "&Omega;");
        htmlEncodeChars.put(Character.valueOf('\u03b1'), "&alpha;");
        htmlEncodeChars.put(Character.valueOf('\u03b2'), "&beta;");
        htmlEncodeChars.put(Character.valueOf('\u03b3'), "&gamma;");
        htmlEncodeChars.put(Character.valueOf('\u03b4'), "&delta;");
        htmlEncodeChars.put(Character.valueOf('\u03b5'), "&epsilon;");
        htmlEncodeChars.put(Character.valueOf('\u03b6'), "&zeta;");
        htmlEncodeChars.put(Character.valueOf('\u03b7'), "&eta;");
        htmlEncodeChars.put(Character.valueOf('\u03b8'), "&theta;");
        htmlEncodeChars.put(Character.valueOf('\u03b9'), "&iota;");
        htmlEncodeChars.put(Character.valueOf('\u03ba'), "&kappa;");
        htmlEncodeChars.put(Character.valueOf('\u03bb'), "&lambda;");
        htmlEncodeChars.put(Character.valueOf('\u03bc'), "&mu;");
        htmlEncodeChars.put(Character.valueOf('\u03bd'), "&nu;");
        htmlEncodeChars.put(Character.valueOf('\u03be'), "&xi;");
        htmlEncodeChars.put(Character.valueOf('\u03bf'), "&omicron;");
        htmlEncodeChars.put(Character.valueOf('\u03c0'), "&pi;");
        htmlEncodeChars.put(Character.valueOf('\u03c1'), "&rho;");
        htmlEncodeChars.put(Character.valueOf('\u03c2'), "&sigmaf;");
        htmlEncodeChars.put(Character.valueOf('\u03c3'), "&sigma;");
        htmlEncodeChars.put(Character.valueOf('\u03c4'), "&tau;");
        htmlEncodeChars.put(Character.valueOf('\u03c5'), "&upsilon;");
        htmlEncodeChars.put(Character.valueOf('\u03c6'), "&phi;");
        htmlEncodeChars.put(Character.valueOf('\u03c7'), "&chi;");
        htmlEncodeChars.put(Character.valueOf('\u03c8'), "&psi;");
        htmlEncodeChars.put(Character.valueOf('\u03c9'), "&omega;");
        htmlEncodeChars.put(Character.valueOf('\u03d1'), "&thetasym;");
        htmlEncodeChars.put(Character.valueOf('\u03d2'), "&upsih;");
        htmlEncodeChars.put(Character.valueOf('\u03d6'), "&piv;");
        htmlEncodeChars.put(Character.valueOf('\u2022'), "&bull;");
        htmlEncodeChars.put(Character.valueOf('\u2026'), "&hellip;");
        htmlEncodeChars.put(Character.valueOf('\u2032'), "&prime;");
        htmlEncodeChars.put(Character.valueOf('\u2033'), "&Prime;");
        htmlEncodeChars.put(Character.valueOf('\u203e'), "&oline;");
        htmlEncodeChars.put(Character.valueOf('\u2044'), "&frasl;");
        htmlEncodeChars.put(Character.valueOf('\u2118'), "&weierp;");
        htmlEncodeChars.put(Character.valueOf('\u2111'), "&image;");
        htmlEncodeChars.put(Character.valueOf('\u211c'), "&real;");
        htmlEncodeChars.put(Character.valueOf('\u2122'), "&trade;");
        htmlEncodeChars.put(Character.valueOf('\u2135'), "&alefsym;");
        htmlEncodeChars.put(Character.valueOf('\u2190'), "&larr;");
        htmlEncodeChars.put(Character.valueOf('\u2191'), "&uarr;");
        htmlEncodeChars.put(Character.valueOf('\u2192'), "&rarr;");
        htmlEncodeChars.put(Character.valueOf('\u2193'), "&darr;");
        htmlEncodeChars.put(Character.valueOf('\u2194'), "&harr;");
        htmlEncodeChars.put(Character.valueOf('\u21b5'), "&crarr;");
        htmlEncodeChars.put(Character.valueOf('\u21d0'), "&lArr;");
        htmlEncodeChars.put(Character.valueOf('\u21d1'), "&uArr;");
        htmlEncodeChars.put(Character.valueOf('\u21d2'), "&rArr;");
        htmlEncodeChars.put(Character.valueOf('\u21d3'), "&dArr;");
        htmlEncodeChars.put(Character.valueOf('\u21d4'), "&hArr;");
        htmlEncodeChars.put(Character.valueOf('\u2200'), "&forall;");
        htmlEncodeChars.put(Character.valueOf('\u2202'), "&part;");
        htmlEncodeChars.put(Character.valueOf('\u2203'), "&exist;");
        htmlEncodeChars.put(Character.valueOf('\u2205'), "&empty;");
        htmlEncodeChars.put(Character.valueOf('\u2207'), "&nabla;");
        htmlEncodeChars.put(Character.valueOf('\u2208'), "&isin;");
        htmlEncodeChars.put(Character.valueOf('\u2209'), "&notin;");
        htmlEncodeChars.put(Character.valueOf('\u220b'), "&ni;");
        htmlEncodeChars.put(Character.valueOf('\u220f'), "&prod;");
        htmlEncodeChars.put(Character.valueOf('\u2211'), "&sum;");
        htmlEncodeChars.put(Character.valueOf('\u2212'), "&minus;");
        htmlEncodeChars.put(Character.valueOf('\u2217'), "&lowast;");
        htmlEncodeChars.put(Character.valueOf('\u221a'), "&radic;");
        htmlEncodeChars.put(Character.valueOf('\u221d'), "&prop;");
        htmlEncodeChars.put(Character.valueOf('\u221e'), "&infin;");
        htmlEncodeChars.put(Character.valueOf('\u2220'), "&ang;");
        htmlEncodeChars.put(Character.valueOf('\u2227'), "&and;");
        htmlEncodeChars.put(Character.valueOf('\u2228'), "&or;");
        htmlEncodeChars.put(Character.valueOf('\u2229'), "&cap;");
        htmlEncodeChars.put(Character.valueOf('\u222a'), "&cup;");
        htmlEncodeChars.put(Character.valueOf('\u222b'), "&int;");
        htmlEncodeChars.put(Character.valueOf('\u2234'), "&there4;");
        htmlEncodeChars.put(Character.valueOf('\u223c'), "&sim;");
        htmlEncodeChars.put(Character.valueOf('\u2245'), "&cong;");
        htmlEncodeChars.put(Character.valueOf('\u2248'), "&asymp;");
        htmlEncodeChars.put(Character.valueOf('\u2260'), "&ne;");
        htmlEncodeChars.put(Character.valueOf('\u2261'), "&equiv;");
        htmlEncodeChars.put(Character.valueOf('\u2264'), "&le;");
        htmlEncodeChars.put(Character.valueOf('\u2265'), "&ge;");
        htmlEncodeChars.put(Character.valueOf('\u2282'), "&sub;");
        htmlEncodeChars.put(Character.valueOf('\u2283'), "&sup;");
        htmlEncodeChars.put(Character.valueOf('\u2284'), "&nsub;");
        htmlEncodeChars.put(Character.valueOf('\u2286'), "&sube;");
        htmlEncodeChars.put(Character.valueOf('\u2287'), "&supe;");
        htmlEncodeChars.put(Character.valueOf('\u2295'), "&oplus;");
        htmlEncodeChars.put(Character.valueOf('\u2297'), "&otimes;");
        htmlEncodeChars.put(Character.valueOf('\u22a5'), "&perp;");
        htmlEncodeChars.put(Character.valueOf('\u22c5'), "&sdot;");
        htmlEncodeChars.put(Character.valueOf('\u2308'), "&lceil;");
        htmlEncodeChars.put(Character.valueOf('\u2309'), "&rceil;");
        htmlEncodeChars.put(Character.valueOf('\u230a'), "&lfloor;");
        htmlEncodeChars.put(Character.valueOf('\u230b'), "&rfloor;");
        htmlEncodeChars.put(Character.valueOf('\u2329'), "&lang;");
        htmlEncodeChars.put(Character.valueOf('\u232a'), "&rang;");
        htmlEncodeChars.put(Character.valueOf('\u25ca'), "&loz;");
        htmlEncodeChars.put(Character.valueOf('\u2660'), "&spades;");
        htmlEncodeChars.put(Character.valueOf('\u2663'), "&clubs;");
        htmlEncodeChars.put(Character.valueOf('\u2665'), "&hearts;");
        htmlEncodeChars.put(Character.valueOf('\u2666'), "&diams;");
    }
}

