/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.util.StreamIOException;
import org.weasis.core.util.StringUtil;

public final class FileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);
    public static final int FILE_BUFFER = 4096;
    private static final int[] ILLEGAL_CHARS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 34, 42, 47, 58, 60, 62, 63, 92, 124};
    public static final String CANNOT_DELETE = "Cannot delete";

    private FileUtil() {
    }

    public static String getValidFileName(String fileName) {
        StringBuilder cleanName = new StringBuilder();
        if (fileName != null) {
            for (int i = 0; i < fileName.length(); ++i) {
                char c = fileName.charAt(i);
                if (Arrays.binarySearch(ILLEGAL_CHARS, (int)c) >= 0 || c < ' ' || c > '~' && c < '\u00a0') continue;
                cleanName.append(c);
            }
        }
        return cleanName.toString().trim();
    }

    public static String getValidFileNameWithoutHTML(String fileName) {
        String val = null;
        if (fileName != null) {
            val = fileName.replaceAll("<[^>]*>", "");
        }
        return FileUtil.getValidFileName(val);
    }

    public static void safeClose(AutoCloseable autoCloseable) {
        if (autoCloseable != null) {
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                LOGGER.error("Cannot close AutoCloseable", (Throwable)e);
            }
        }
    }

    public static File createTempDir(File baseDir) {
        if (baseDir != null && baseDir.isDirectory()) {
            String baseName = String.valueOf(System.currentTimeMillis());
            for (int counter = 0; counter < 1000; ++counter) {
                File tempDir = new File(baseDir, baseName + counter);
                if (!tempDir.mkdir()) continue;
                return tempDir;
            }
        }
        throw new IllegalStateException("Failed to create directory");
    }

    public static void deleteDirectoryContents(File dir, int deleteDirLevel, int level) {
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    FileUtil.deleteDirectoryContents(f, deleteDirLevel, level + 1);
                    continue;
                }
                FileUtil.deleteFile(f);
            }
        }
        if (level >= deleteDirLevel) {
            FileUtil.deleteFile(dir);
        }
    }

    public static void getAllFilesInDirectory(File directory, List<File> files) {
        FileUtil.getAllFilesInDirectory(directory, files, true);
    }

    public static void getAllFilesInDirectory(File directory, List<File> files, boolean recursive) {
        File[] fList = directory.listFiles();
        if (fList != null) {
            for (File f : fList) {
                if (f.isFile()) {
                    files.add(f);
                    continue;
                }
                if (!recursive || !f.isDirectory()) continue;
                FileUtil.getAllFilesInDirectory(f, files, true);
            }
        }
    }

    static boolean deleteFile(File fileOrDirectory) {
        try {
            Files.delete(fileOrDirectory.toPath());
        }
        catch (Exception e) {
            LOGGER.error(CANNOT_DELETE, (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean delete(File fileOrDirectory) {
        File[] files;
        if (fileOrDirectory == null || !fileOrDirectory.exists()) {
            return false;
        }
        if (fileOrDirectory.isDirectory() && (files = fileOrDirectory.listFiles()) != null) {
            for (File child : files) {
                FileUtil.delete(child);
            }
        }
        return FileUtil.deleteFile(fileOrDirectory);
    }

    public static void recursiveDelete(File rootDir) {
        FileUtil.recursiveDelete(rootDir, true);
    }

    public static void recursiveDelete(File rootDir, boolean deleteRoot) {
        if (rootDir == null || !rootDir.isDirectory()) {
            return;
        }
        File[] childDirs = rootDir.listFiles();
        if (childDirs != null) {
            for (File f : childDirs) {
                if (f.isDirectory()) {
                    FileUtil.recursiveDelete(f, false);
                    FileUtil.deleteFile(f);
                    continue;
                }
                FileUtil.deleteFile(f);
            }
        }
        if (deleteRoot) {
            FileUtil.deleteFile(rootDir);
        }
    }

    public static void safeClose(XMLStreamWriter writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (XMLStreamException e) {
                LOGGER.error("Cannot close XMLStreamWriter", (Throwable)e);
            }
        }
    }

    public static void safeClose(XMLStreamReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (XMLStreamException e) {
                LOGGER.error("Cannot close XMLStreamException", (Throwable)e);
            }
        }
    }

    public static void prepareToWriteFile(File file) throws IOException {
        File outputDir;
        if (!(file.exists() || (outputDir = file.getParentFile()) == null || outputDir.exists() || outputDir.mkdirs())) {
            throw new IOException("Cannot write parent directory of " + file.getPath());
        }
    }

    public static String nameWithoutExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int i = filename.lastIndexOf(46);
        if (i > 0) {
            return filename.substring(0, i);
        }
        return filename;
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return "";
        }
        int i = filename.lastIndexOf(46);
        if (i > 0) {
            return filename.substring(i);
        }
        return "";
    }

    public static boolean isFileExtensionMatching(File file, String[] extensions) {
        String fileExt;
        if (file != null && extensions != null && StringUtil.hasLength(fileExt = FileUtil.getExtension(file.getName()))) {
            for (String extension : extensions) {
                Object ext;
                if (!StringUtil.hasText(extension)) continue;
                Object object = ext = extension.startsWith(".") ? extension : "." + extension;
                if (!fileExt.equalsIgnoreCase((String)ext)) continue;
                return true;
            }
        }
        return false;
    }

    public static void writeStreamWithIOException(InputStream inputStream, File outFile) throws StreamIOException {
        try (FileOutputStream outputStream = new FileOutputStream(outFile);){
            int offset;
            byte[] buf = new byte[4096];
            while ((offset = inputStream.read(buf)) > 0) {
                outputStream.write(buf, 0, offset);
            }
            outputStream.flush();
        }
        catch (IOException e) {
            FileUtil.delete(outFile);
            throw new StreamIOException(e);
        }
        finally {
            FileUtil.safeClose(inputStream);
        }
    }

    public static int writeStream(InputStream inputStream, File outFile) throws StreamIOException {
        return FileUtil.writeStream(inputStream, outFile, true);
    }

    public static int writeStream(InputStream inputStream, File outFile, boolean closeInputStream) throws StreamIOException {
        try {
            int n;
            FileOutputStream outputStream = new FileOutputStream(outFile);
            try {
                int offset;
                byte[] buf = new byte[4096];
                while ((offset = inputStream.read(buf)) > 0) {
                    outputStream.write(buf, 0, offset);
                }
                outputStream.flush();
                n = -1;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (SocketTimeoutException e) {
                    FileUtil.delete(outFile);
                    throw new StreamIOException(e);
                }
                catch (InterruptedIOException e) {
                    FileUtil.delete(outFile);
                    LOGGER.error("Interruption when writing file: {}", (Object)e.getMessage());
                    int n2 = e.bytesTransferred;
                    return n2;
                }
                catch (IOException e) {
                    FileUtil.delete(outFile);
                    throw new StreamIOException(e);
                }
            }
            outputStream.close();
            return n;
        }
        finally {
            if (closeInputStream) {
                FileUtil.safeClose(inputStream);
            }
        }
    }

    public static int writeFile(ImageInputStream imageInputStream, File outFile) throws StreamIOException {
        try {
            int n;
            FileOutputStream outputStream = new FileOutputStream(outFile);
            try {
                int offset;
                byte[] buf = new byte[4096];
                while ((offset = imageInputStream.read(buf)) > 0) {
                    outputStream.write(buf, 0, offset);
                }
                outputStream.flush();
                n = -1;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (SocketTimeoutException e) {
                    FileUtil.delete(outFile);
                    throw new StreamIOException(e);
                }
                catch (InterruptedIOException e) {
                    FileUtil.delete(outFile);
                    LOGGER.error("Interruption when writing image {}", (Object)e.getMessage());
                    int n2 = e.bytesTransferred;
                    return n2;
                }
                catch (IOException e) {
                    FileUtil.delete(outFile);
                    throw new StreamIOException(e);
                }
            }
            outputStream.close();
            return n;
        }
        finally {
            FileUtil.safeClose(imageInputStream);
        }
    }

    public static String humanReadableByte(long bytes, boolean si) {
        long absBytes;
        int unit = si ? 1000 : 1024;
        long l = absBytes = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        if (absBytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(absBytes) / Math.log(unit));
        long th = (long)Math.ceil(Math.pow(unit, exp) * ((double)unit - 0.05));
        if (exp < 6 && absBytes >= th - (long)((th & 0xFFFL) == 3328L ? 51 : 0)) {
            ++exp;
        }
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        if (exp > 4) {
            bytes /= (long)unit;
            --exp;
        }
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    /*
     * Exception decompiling
     */
    public static boolean nioWriteFile(FileInputStream inputStream, FileOutputStream out) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static boolean nioWriteFile(InputStream in, OutputStream out, int bufferSize) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean nioCopyFile(File source, File destination) {
        if (source == null || destination == null) {
            return false;
        }
        try {
            Files.copy(source.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Copy file", (Throwable)e);
            return false;
        }
    }

    public static Properties readProperties(File propsFile, Properties props) {
        Properties p;
        Properties properties = p = props == null ? new Properties() : props;
        if (propsFile != null && propsFile.canRead()) {
            try (FileInputStream fileStream = new FileInputStream(propsFile);){
                p.load(fileStream);
            }
            catch (IOException e) {
                LOGGER.error("Error when reading properties", (Throwable)e);
            }
        }
        return p;
    }

    public static void storeProperties(File propsFile, Properties props, String comments) {
        if (props != null && propsFile != null) {
            try (FileOutputStream stream = new FileOutputStream(propsFile);){
                props.store(stream, comments);
            }
            catch (IOException e) {
                LOGGER.error("Error when writing properties", (Throwable)e);
            }
        }
    }

    public static void zip(File directory, File zipFile) throws IOException {
        if (zipFile == null || directory == null) {
            return;
        }
        URI base = directory.toURI();
        LinkedList<File> queue = new LinkedList<File>();
        queue.push(directory);
        try (OutputStream out = Files.newOutputStream(zipFile.toPath(), new OpenOption[0]);
             ZipOutputStream zipOut = new ZipOutputStream(out);){
            while (!queue.isEmpty()) {
                File dir = (File)queue.pop();
                File[] files = dir.listFiles();
                if (files == null) continue;
                for (File entry : files) {
                    Object name = base.relativize(entry.toURI()).getPath();
                    if (entry.isDirectory()) {
                        queue.push(entry);
                        String[] flist = entry.list();
                        if (flist != null && flist.length != 0) continue;
                        name = ((String)name).endsWith("/") ? name : (String)name + "/";
                        zipOut.putNextEntry(new ZipEntry((String)name));
                        continue;
                    }
                    zipOut.putNextEntry(new ZipEntry((String)name));
                    FileUtil.copyZip(entry, zipOut);
                    zipOut.closeEntry();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(InputStream inputStream, File directory) throws IOException {
        if (inputStream == null || directory == null) {
            return;
        }
        try (BufferedInputStream bufInStream = new BufferedInputStream(inputStream);
             ZipInputStream zis = new ZipInputStream(bufInStream);){
            ZipEntry entry;
            String canonicalDirPath = directory.getCanonicalPath();
            while ((entry = zis.getNextEntry()) != null) {
                File file = new File(directory, entry.getName());
                String canonicalDestPath = file.getCanonicalPath();
                if (!canonicalDestPath.startsWith(canonicalDirPath + File.separator)) {
                    throw new IOException("Security issue: Entry is trying to leave the target dir: " + entry.getName());
                }
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                file.getParentFile().mkdirs();
                FileUtil.copyZip(zis, file);
            }
        }
        finally {
            FileUtil.safeClose(inputStream);
        }
    }

    public static void unzip(File zipFile, File directory) throws IOException {
        if (zipFile == null || directory == null) {
            return;
        }
        try (ZipFile zFile = new ZipFile(zipFile);){
            String canonicalDirPath = directory.getCanonicalPath();
            Enumeration<? extends ZipEntry> entries = zFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File file = new File(directory, entry.getName());
                String canonicalDestPath = file.getCanonicalPath();
                if (!canonicalDestPath.startsWith(canonicalDirPath + File.separator)) {
                    throw new IOException("Security issue: Entry is trying to leave the target dir: " + entry.getName());
                }
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                file.getParentFile().mkdirs();
                InputStream in = zFile.getInputStream(entry);
                try {
                    FileUtil.copyZip(in, file);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int offset;
        byte[] buf = new byte[4096];
        while ((offset = in.read(buf)) > 0) {
            out.write(buf, 0, offset);
        }
        out.flush();
    }

    public static void copyFolder(final Path source, final Path target, final CopyOption ... options) throws IOException {
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(target.resolve(source.relativize(dir)), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, target.resolve(source.relativize(file)), options);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void copyZip(File file, OutputStream out) throws IOException {
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            FileUtil.copy(in, out);
        }
    }

    private static void copyZip(InputStream in, File file) throws IOException {
        try (OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            FileUtil.copy(in, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeStream(InputStream inputStream, Path outFile, boolean closeInputStream) {
        try {
            boolean bl;
            block13: {
                OutputStream outputStream = Files.newOutputStream(outFile, new OpenOption[0]);
                try {
                    int offset;
                    byte[] buf = new byte[4096];
                    while ((offset = inputStream.read(buf)) > 0) {
                        outputStream.write(buf, 0, offset);
                    }
                    outputStream.flush();
                    bl = true;
                    if (outputStream == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        FileUtil.delete(outFile);
                        LOGGER.error("Writing file: {}", (Object)outFile, (Object)e);
                        boolean bl2 = false;
                        return bl2;
                    }
                }
                outputStream.close();
            }
            return bl;
        }
        finally {
            if (closeInputStream) {
                FileUtil.safeClose(inputStream);
            }
        }
    }

    static boolean deleteFile(Path path) {
        try {
            return Files.deleteIfExists(path);
        }
        catch (IOException e) {
            LOGGER.error(CANNOT_DELETE, (Throwable)e);
            return false;
        }
    }

    public static boolean delete(Path fileOrDirectory) {
        boolean bl;
        block9: {
            if (!Files.isDirectory(fileOrDirectory, new LinkOption[0])) {
                return FileUtil.deleteFile(fileOrDirectory);
            }
            Stream<Path> walk = Files.walk(fileOrDirectory, new FileVisitOption[0]);
            try {
                walk.sorted(Comparator.reverseOrder()).forEach(FileUtil::deleteFile);
                bl = true;
                if (walk == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error(CANNOT_DELETE, (Throwable)e);
                    return false;
                }
            }
            walk.close();
        }
        return bl;
    }

    public static Path getOutputPath(Path input, Path output) {
        if (Files.isDirectory(output, new LinkOption[0])) {
            return FileSystems.getDefault().getPath(output.toString(), input.getFileName().toString());
        }
        return output;
    }

    public static Path addFileIndex(Path path, int index, int indexSize) {
        if (indexSize < 1) {
            return path;
        }
        String pattern = "$1-%0" + indexSize + "d$2";
        String insert = String.format(pattern, index);
        return path.resolveSibling(path.getFileName().toString().replaceFirst("(.*?)(\\.[^.]+)?$", insert));
    }
}

