/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.util;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class SoftHashMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    protected final transient Map<K, SoftReference<V>> hash = new HashMap<K, SoftReference<V>>();
    protected final transient Map<SoftReference<V>, K> reverseLookup = new HashMap<SoftReference<V>, K>();
    private final transient ReferenceQueue<V> queue = new ReferenceQueue();

    @Override
    public V get(Object key) {
        this.expungeStaleEntries();
        V result = null;
        SoftReference<V> softRef = this.hash.get(key);
        if (softRef != null && (result = (V)softRef.get()) == null) {
            this.removeElement(softRef);
        }
        return result;
    }

    public void removeElement(Reference<? extends V> soft) {
        K key = this.reverseLookup.remove(soft);
        if (key != null) {
            this.hash.remove(key);
        }
    }

    public void expungeStaleEntries() {
        Reference<V> sv;
        while ((sv = this.queue.poll()) != null) {
            this.removeElement(sv);
        }
    }

    @Override
    public V put(K key, V value) {
        this.expungeStaleEntries();
        SoftReference<V> softRef = new SoftReference<V>(value, this.queue);
        this.reverseLookup.put((SoftReference<K>)softRef, (SoftReference<V>)key);
        SoftReference<V> result = this.hash.put(key, softRef);
        if (result == null) {
            return null;
        }
        this.reverseLookup.remove(result);
        return result.get();
    }

    @Override
    public V remove(Object key) {
        this.expungeStaleEntries();
        SoftReference<V> result = this.hash.remove(key);
        if (result == null) {
            return null;
        }
        this.reverseLookup.remove(result);
        return result.get();
    }

    @Override
    public void clear() {
        this.hash.clear();
        this.reverseLookup.clear();
    }

    @Override
    public int size() {
        this.expungeStaleEntries();
        return this.hash.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.expungeStaleEntries();
        LinkedHashSet<Map.Entry<K, V>> result = new LinkedHashSet<Map.Entry<K, V>>();
        for (final Map.Entry<K, SoftReference<V>> entry : this.hash.entrySet()) {
            final V value = entry.getValue().get();
            if (value == null) continue;
            result.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return entry.getKey();
                }

                @Override
                public V getValue() {
                    return value;
                }

                @Override
                public V setValue(V v) {
                    entry.setValue(new SoftReference(v, SoftHashMap.this.queue));
                    return value;
                }
            });
        }
        return result;
    }

    @Override
    public boolean containsKey(Object key) {
        this.expungeStaleEntries();
        SoftReference<V> softRef = this.hash.get(key);
        if (softRef != null) {
            V result = softRef.get();
            if (result != null) {
                return true;
            }
            this.hash.remove(key);
            this.reverseLookup.remove(softRef);
        }
        return false;
    }
}

