/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.opencv.op;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.imgproc.Imgproc;
import org.weasis.opencv.data.ImageCV;
import org.weasis.opencv.data.PlanarImage;

public class ImageConversion {
    private ImageConversion() {
    }

    public static BufferedImage toBufferedImage(Mat matrix) {
        ComponentColorModel colorModel;
        if (matrix == null) {
            return null;
        }
        int cols = matrix.cols();
        int rows = matrix.rows();
        int type = matrix.type();
        int elemSize = CvType.ELEM_SIZE(type);
        int channels = CvType.channels(type);
        int bpp = elemSize * 8 / channels;
        int dataType = ImageConversion.convertToDataType(type);
        WritableRaster raster = switch (channels) {
            case 1 -> {
                ColorSpace cs = ColorSpace.getInstance(1003);
                colorModel = new ComponentColorModel(cs, new int[]{bpp}, false, true, 1, dataType);
                yield colorModel.createCompatibleWritableRaster(cols, rows);
            }
            case 3 -> {
                ColorSpace cs = ColorSpace.getInstance(1000);
                colorModel = new ComponentColorModel(cs, new int[]{bpp, bpp, bpp}, false, false, 1, dataType);
                yield Raster.createInterleavedRaster(dataType, cols, rows, cols * channels, channels, new int[]{2, 1, 0}, null);
            }
            default -> throw new UnsupportedOperationException("No implementation to handle " + channels + " channels");
        };
        DataBuffer buf = raster.getDataBuffer();
        if (buf instanceof DataBufferByte) {
            DataBufferByte bufferByte = (DataBufferByte)buf;
            matrix.get(0, 0, bufferByte.getData());
        } else if (buf instanceof DataBufferUShort) {
            DataBufferUShort bufferUShort = (DataBufferUShort)buf;
            matrix.get(0, 0, bufferUShort.getData());
        } else if (buf instanceof DataBufferShort) {
            DataBufferShort bufferShort = (DataBufferShort)buf;
            matrix.get(0, 0, bufferShort.getData());
        } else if (buf instanceof DataBufferInt) {
            DataBufferInt bufferInt = (DataBufferInt)buf;
            matrix.get(0, 0, bufferInt.getData());
        } else if (buf instanceof DataBufferFloat) {
            DataBufferFloat bufferFloat = (DataBufferFloat)buf;
            matrix.get(0, 0, bufferFloat.getData());
        } else if (buf instanceof DataBufferDouble) {
            DataBufferDouble bufferDouble = (DataBufferDouble)buf;
            matrix.get(0, 0, bufferDouble.getData());
        }
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static BufferedImage toBufferedImage(PlanarImage matrix) {
        if (matrix == null) {
            return null;
        }
        return ImageConversion.toBufferedImage(matrix.toMat());
    }

    public static void releaseMat(Mat mat) {
        if (mat != null) {
            mat.release();
        }
    }

    public static void releasePlanarImage(PlanarImage img) {
        if (img != null) {
            img.release();
        }
    }

    public static int convertToDataType(int cvType) {
        return switch (CvType.depth(cvType)) {
            case 0, 1 -> 0;
            case 2 -> 1;
            case 3 -> 2;
            case 4 -> 3;
            case 5 -> 4;
            case 6 -> 5;
            default -> throw new UnsupportedOperationException("Unsupported CvType value: " + cvType);
        };
    }

    public static ImageCV toMat(RenderedImage img) {
        return ImageConversion.toMat(img, null);
    }

    public static ImageCV toMat(RenderedImage img, Rectangle region) {
        return ImageConversion.toMat(img, region, true);
    }

    public static ImageCV toMat(RenderedImage img, Rectangle region, boolean toBGR) {
        return ImageConversion.toMat(img, region, toBGR, false);
    }

    public static ImageCV toMat(RenderedImage img, Rectangle region, boolean toBGR, boolean forceShortType) {
        int[] offsets;
        Raster raster = region == null ? img.getData() : img.getData(region);
        DataBuffer buf = raster.getDataBuffer();
        int[] samples = raster.getSampleModel().getSampleSize();
        SampleModel sampleModel = raster.getSampleModel();
        if (sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel model = (ComponentSampleModel)sampleModel;
            offsets = model.getBandOffsets();
        } else {
            offsets = new int[samples.length];
            for (int i = 0; i < offsets.length; ++i) {
                offsets[i] = i;
            }
        }
        if (ImageConversion.isBinary(raster.getSampleModel())) {
            ImageCV mat = new ImageCV(raster.getHeight(), raster.getWidth(), CvType.CV_8UC1);
            mat.put(0, 0, ImageConversion.getUnpackedBinaryData(raster, raster.getBounds()));
            return mat;
        }
        if (buf instanceof DataBufferByte) {
            DataBufferByte bufferByte = (DataBufferByte)buf;
            if (Arrays.equals(offsets, new int[]{0, 0, 0})) {
                Mat b = new Mat(raster.getHeight(), raster.getWidth(), CvType.CV_8UC1);
                b.put(0, 0, bufferByte.getData(2));
                Mat g = new Mat(raster.getHeight(), raster.getWidth(), CvType.CV_8UC1);
                g.put(0, 0, bufferByte.getData(1));
                ImageCV r = new ImageCV(raster.getHeight(), raster.getWidth(), CvType.CV_8UC1);
                r.put(0, 0, bufferByte.getData(0));
                List<Mat> mv = toBGR ? Arrays.asList(b, g, r) : Arrays.asList(r, g, b);
                ImageCV dstImg = new ImageCV(raster.getHeight(), raster.getWidth(), CvType.CV_8UC3);
                Core.merge(mv, dstImg);
                return dstImg;
            }
            ImageCV mat = new ImageCV(raster.getHeight(), raster.getWidth(), CvType.CV_8UC(samples.length));
            mat.put(0, 0, ((DataBufferByte)buf).getData());
            if (toBGR && Arrays.equals(offsets, new int[]{0, 1, 2})) {
                ImageCV dstImg = new ImageCV();
                Imgproc.cvtColor(mat, dstImg, 4);
                return dstImg;
            }
            if (!toBGR && Arrays.equals(offsets, new int[]{2, 1, 0})) {
                ImageCV dstImg = new ImageCV();
                Imgproc.cvtColor(mat, dstImg, 4);
                return dstImg;
            }
            return mat;
        }
        if (buf instanceof DataBufferUShort) {
            DataBufferUShort bufferUShort = (DataBufferUShort)buf;
            ImageCV mat = new ImageCV(raster.getHeight(), raster.getWidth(), forceShortType ? CvType.CV_16SC(samples.length) : CvType.CV_16UC(samples.length));
            mat.put(0, 0, bufferUShort.getData());
            return mat;
        }
        if (buf instanceof DataBufferShort) {
            DataBufferShort bufferShort = (DataBufferShort)buf;
            ImageCV mat = new ImageCV(raster.getHeight(), raster.getWidth(), CvType.CV_16SC(samples.length));
            mat.put(0, 0, bufferShort.getData());
            return mat;
        }
        if (buf instanceof DataBufferInt) {
            DataBufferInt bufferInt = (DataBufferInt)buf;
            ImageCV mat = new ImageCV(raster.getHeight(), raster.getWidth(), CvType.CV_32SC(samples.length));
            mat.put(0, 0, bufferInt.getData());
            return mat;
        }
        if (buf instanceof DataBufferFloat) {
            DataBufferFloat bufferFloat = (DataBufferFloat)buf;
            ImageCV mat = new ImageCV(raster.getHeight(), raster.getWidth(), CvType.CV_32FC(samples.length));
            mat.put(0, 0, bufferFloat.getData());
            return mat;
        }
        if (buf instanceof DataBufferDouble) {
            DataBufferDouble bufferDouble = (DataBufferDouble)buf;
            ImageCV mat = new ImageCV(raster.getHeight(), raster.getWidth(), CvType.CV_64FC(samples.length));
            mat.put(0, 0, bufferDouble.getData());
            return mat;
        }
        return null;
    }

    public static Rectangle getBounds(PlanarImage img) {
        return new Rectangle(0, 0, img.width(), img.height());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage convertTo(RenderedImage src, int imageType) {
        BufferedImage dst = new BufferedImage(src.getWidth(), src.getHeight(), imageType);
        Graphics2D big = dst.createGraphics();
        try {
            big.drawRenderedImage(src, AffineTransform.getTranslateInstance(0.0, 0.0));
        }
        finally {
            big.dispose();
        }
        return dst;
    }

    public static boolean isBinary(SampleModel sm) {
        MultiPixelPackedSampleModel model;
        return sm instanceof MultiPixelPackedSampleModel && (model = (MultiPixelPackedSampleModel)sm).getPixelBitStride() == 1 && sm.getNumBands() == 1;
    }

    public static BufferedImage convertRenderedImage(RenderedImage img) {
        if (img == null) {
            return null;
        }
        if (img instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)img;
            return bufferedImage;
        }
        ColorModel cm = img.getColorModel();
        int width = img.getWidth();
        int height = img.getHeight();
        WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        String[] keys = img.getPropertyNames();
        if (keys != null) {
            for (String key : keys) {
                properties.put(key, img.getProperty(key));
            }
        }
        BufferedImage result = new BufferedImage(cm, raster, isAlphaPremultiplied, properties);
        img.copyData(raster);
        return result;
    }

    public static byte[] getUnpackedBinaryData(Raster raster, Rectangle rect) {
        byte[] bData;
        block10: {
            int maxX;
            int maxY;
            int bitOffset;
            int eltOffset;
            int lineStride;
            DataBuffer dataBuffer;
            block11: {
                short[] sArray;
                block9: {
                    SampleModel sm = raster.getSampleModel();
                    if (!ImageConversion.isBinary(sm)) {
                        throw new IllegalArgumentException("Not a binary raster!");
                    }
                    int rectX = rect.x;
                    int rectY = rect.y;
                    int rectWidth = rect.width;
                    int rectHeight = rect.height;
                    dataBuffer = raster.getDataBuffer();
                    int dx = rectX - raster.getSampleModelTranslateX();
                    int dy = rectY - raster.getSampleModelTranslateY();
                    MultiPixelPackedSampleModel mpp = (MultiPixelPackedSampleModel)sm;
                    lineStride = mpp.getScanlineStride();
                    eltOffset = dataBuffer.getOffset() + mpp.getOffset(dx, dy);
                    bitOffset = mpp.getBitOffset(dx);
                    bData = new byte[rectWidth * rectHeight];
                    maxY = rectY + rectHeight;
                    maxX = rectX + rectWidth;
                    int k = 0;
                    if (!(dataBuffer instanceof DataBufferByte)) break block9;
                    DataBufferByte bufferByte = (DataBufferByte)dataBuffer;
                    byte[] data = bufferByte.getData();
                    for (int y = rectY; y < maxY; ++y) {
                        int bOffset = eltOffset * 8 + bitOffset;
                        for (int x = rectX; x < maxX; ++x) {
                            byte b = data[bOffset / 8];
                            bData[k++] = (byte)(b >>> (7 - bOffset & 7) & 1);
                            ++bOffset;
                        }
                        eltOffset += lineStride;
                    }
                    break block10;
                }
                if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block11;
                if (dataBuffer instanceof DataBufferShort) {
                    DataBufferShort bufferShort = (DataBufferShort)dataBuffer;
                    sArray = bufferShort.getData();
                } else {
                    sArray = ((DataBufferUShort)dataBuffer).getData();
                }
                short[] data = sArray;
                for (int y = rectY; y < maxY; ++y) {
                    int bOffset = eltOffset * 16 + bitOffset;
                    for (int x = rectX; x < maxX; ++x) {
                        short s = data[bOffset / 16];
                        bData[k++] = (byte)(s >>> 15 - bOffset % 16 & 1);
                        ++bOffset;
                    }
                    eltOffset += lineStride;
                }
                break block10;
            }
            if (!(dataBuffer instanceof DataBufferInt)) break block10;
            DataBufferInt bufferInt = (DataBufferInt)dataBuffer;
            int[] data = bufferInt.getData();
            for (int y = rectY; y < maxY; ++y) {
                int bOffset = eltOffset * 32 + bitOffset;
                for (int x = rectX; x < maxX; ++x) {
                    int i = data[bOffset / 32];
                    bData[k++] = (byte)(i >>> 31 - bOffset % 32 & 1);
                    ++bOffset;
                }
                eltOffset += lineStride;
            }
        }
        return bData;
    }
}

