/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.opencv.op.lut;

import org.weasis.opencv.data.LookupTableCV;

public final class LutShape {
    public static final LutShape LINEAR = new LutShape(eFunction.LINEAR);
    public static final LutShape SIGMOID = new LutShape(eFunction.SIGMOID);
    public static final LutShape SIGMOID_NORM = new LutShape(eFunction.SIGMOID_NORM);
    public static final LutShape LOG = new LutShape(eFunction.LOG);
    public static final LutShape LOG_INV = new LutShape(eFunction.LOG_INV);
    private final eFunction function;
    private final String explanation;
    private final LookupTableCV lookup;

    public LutShape(LookupTableCV lookup, String explanation) {
        if (lookup == null) {
            throw new IllegalArgumentException();
        }
        this.function = null;
        this.explanation = explanation;
        this.lookup = lookup;
    }

    public LutShape(eFunction function) {
        this(function, function.toString());
    }

    public LutShape(eFunction function, String explanation) {
        if (function == null) {
            throw new IllegalArgumentException();
        }
        this.function = function;
        this.explanation = explanation;
        this.lookup = null;
    }

    public eFunction getFunctionType() {
        return this.function;
    }

    public LookupTableCV getLookup() {
        return this.lookup;
    }

    public String toString() {
        return this.explanation;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LutShape) {
            LutShape shape = (LutShape)obj;
            return this.function != null ? this.function.equals((Object)shape.function) : this.lookup.equals(shape.lookup);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.function != null ? this.function.hashCode() : this.lookup.hashCode();
    }

    public static LutShape getLutShape(String shape) {
        if (shape != null) {
            String val;
            return switch (val = shape.toUpperCase()) {
                case "LINEAR" -> LINEAR;
                case "SIGMOID" -> SIGMOID;
                case "SIGMOID_NORM" -> SIGMOID_NORM;
                case "LOG" -> LOG;
                case "LOG_INV" -> LOG_INV;
                default -> null;
            };
        }
        return null;
    }

    public static enum eFunction {
        LINEAR("Linear"),
        SIGMOID("Sigmoid"),
        SIGMOID_NORM("Sigmoid Normalize"),
        LOG("Logarithmic"),
        LOG_INV("Logarithmic Inverse");

        final String explanation;

        private eFunction(String explanation) {
            this.explanation = explanation;
        }

        public String toString() {
            return this.explanation;
        }
    }
}

