/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.opencv.seg;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.imgproc.Imgproc;
import org.weasis.core.util.StringUtil;
import org.weasis.opencv.data.PlanarImage;
import org.weasis.opencv.seg.ContourTopology;
import org.weasis.opencv.seg.RegionAttributes;
import org.weasis.opencv.seg.Segment;

public class Region {
    private final String id;
    protected long numberOfPixels;
    protected List<Segment> segmentList;
    protected RegionAttributes attributes;

    public Region(String id) {
        this(id, null);
    }

    public Region(String id, List<Segment> segmentList) {
        this(id, segmentList, -1);
    }

    public Region(String id, List<Segment> segmentList, int numberOfPixels) {
        this.id = StringUtil.hasText(id) ? id : UUID.randomUUID().toString();
        this.setSegmentList(segmentList, numberOfPixels);
    }

    public String getId() {
        return this.id;
    }

    public List<Segment> getSegmentList() {
        return this.segmentList;
    }

    public void setSegmentList(List<Segment> segmentList) {
        this.setSegmentList(segmentList, -1L);
    }

    public void setSegmentList(List<Segment> segmentList, long numberOfPixels) {
        this.segmentList = segmentList == null ? new ArrayList() : segmentList;
        this.numberOfPixels = numberOfPixels;
        if (numberOfPixels <= 0L) {
            this.numberOfPixels = -1L;
        }
    }

    public RegionAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(RegionAttributes attributes) {
        this.attributes = attributes;
    }

    public long getNumberOfPixels() {
        return this.numberOfPixels;
    }

    public static List<Segment> buildSegmentList(PlanarImage binary) {
        if (binary == null) {
            return Collections.emptyList();
        }
        ArrayList<MatOfPoint> contours = new ArrayList<MatOfPoint>();
        Mat hierarchy = new Mat();
        Imgproc.findContours(binary.toMat(), contours, hierarchy, 3, 2);
        return Region.buildSegmentList(contours, hierarchy);
    }

    public static List<Segment> buildSegmentList(List<MatOfPoint> contours, Mat hierarchy) {
        if (contours == null || hierarchy == null) {
            return Collections.emptyList();
        }
        HashMap<Integer, ContourTopology> contourMap = new HashMap<Integer, ContourTopology>();
        int[] hierarchyData = new int[4];
        for (int i = 0; i < contours.size(); ++i) {
            hierarchy.get(0, i, hierarchyData);
            ContourTopology contourTopology = new ContourTopology(contours.get(i), hierarchyData[3]);
            contourMap.put(i, contourTopology);
        }
        ArrayList<Segment> segmentList = new ArrayList<Segment>();
        for (int i = 0; i < contours.size(); ++i) {
            Segment segment = Region.buildSegment(contourMap, i);
            if (segment == null) continue;
            segmentList.add(segment);
        }
        return segmentList;
    }

    protected static Segment buildSegment(Map<Integer, ContourTopology> contourMap, int index) {
        if (contourMap == null) {
            return null;
        }
        ContourTopology contourTopology = contourMap.get(index);
        if (contourTopology != null) {
            int parent = contourTopology.getParent();
            if (parent >= 0) {
                ContourTopology p = contourMap.get(parent);
                if (p != null) {
                    p.getSegment().addChild(contourTopology.getSegment());
                }
                return null;
            }
            return contourTopology.getSegment();
        }
        return null;
    }

    public double getArea() {
        if (this.numberOfPixels < 0L) {
            return Math.round(Region.calculateArea(this.getSegmentList(), 0));
        }
        return this.numberOfPixels;
    }

    private static double calculateArea(List<Segment> segments, int level) {
        double area = 0.0;
        for (Segment segment : segments) {
            area += (double)(level % 2 == 0 ? 1 : -1) * Region.polygonArea(segment);
            area += Region.calculateArea(segment.getChildren(), level + 1);
        }
        return area;
    }

    private static double polygonArea(Segment segment) {
        double area = 0.0;
        int n = segment.size();
        int j = n - 1;
        int i = 0;
        while (i < n) {
            Point2D pt = (Point2D)segment.get(i);
            Point2D ptNext = (Point2D)segment.get(j);
            area += (ptNext.getX() + pt.getX() + 0.5) * (ptNext.getY() - pt.getY() + 0.5);
            j = i++;
        }
        return Math.abs(area) / 2.0;
    }
}

